package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BlkioStatsBuilder extends BlkioStatsFluentImpl<BlkioStatsBuilder> implements VisitableBuilder<BlkioStats,BlkioStatsBuilder>{

    BlkioStatsFluent<?> fluent;
    Boolean validationEnabled;

    public BlkioStatsBuilder(){
            this(true);
    }
    public BlkioStatsBuilder(Boolean validationEnabled){
            this(new BlkioStats(), validationEnabled);
    }
    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent){
            this(fluent, true);
    }
    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BlkioStats(), validationEnabled);
    }
    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent,BlkioStats instance){
            this(fluent, instance, true);
    }
    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent,BlkioStats instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIoMergedRecursive(instance.getIoMergedRecursive()); 
            fluent.withIoQueueRecursive(instance.getIoQueueRecursive()); 
            fluent.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive()); 
            fluent.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive()); 
            fluent.withIoServicedRecursive(instance.getIoServicedRecursive()); 
            fluent.withIoTimeRecursive(instance.getIoTimeRecursive()); 
            fluent.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive()); 
            fluent.withSectorsRecursive(instance.getSectorsRecursive()); 
            this.validationEnabled = validationEnabled; 
    }
    public BlkioStatsBuilder(BlkioStats instance){
            this(instance,true);
    }
    public BlkioStatsBuilder(BlkioStats instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIoMergedRecursive(instance.getIoMergedRecursive()); 
            this.withIoQueueRecursive(instance.getIoQueueRecursive()); 
            this.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive()); 
            this.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive()); 
            this.withIoServicedRecursive(instance.getIoServicedRecursive()); 
            this.withIoTimeRecursive(instance.getIoTimeRecursive()); 
            this.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive()); 
            this.withSectorsRecursive(instance.getSectorsRecursive()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableBlkioStats build(){
            EditableBlkioStats buildable = new EditableBlkioStats(fluent.getIoMergedRecursive(),fluent.getIoQueueRecursive(),fluent.getIoServiceBytesRecursive(),fluent.getIoServiceTimeRecursive(),fluent.getIoServicedRecursive(),fluent.getIoTimeRecursive(),fluent.getIoWaitTimeRecursive(),fluent.getSectorsRecursive());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BlkioStatsBuilder that = (BlkioStatsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
