package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class BlkioStatEntryFluentImpl<A extends BlkioStatEntryFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements BlkioStatEntryFluent<A>{

    private Long major;
    private Long minor;
    private String op;
    private Long value;

    public BlkioStatEntryFluentImpl(){
    }
    public BlkioStatEntryFluentImpl(BlkioStatEntry instance){
            this.withMajor(instance.getMajor()); 
            this.withMinor(instance.getMinor()); 
            this.withOp(instance.getOp()); 
            this.withValue(instance.getValue()); 
    }

    public Long getMajor(){
            return this.major;
    }

    public A withMajor(Long major){
            this.major=major; return (A) this;
    }

    public Boolean hasMajor(){
            return this.major!=null;
    }

    public Long getMinor(){
            return this.minor;
    }

    public A withMinor(Long minor){
            this.minor=minor; return (A) this;
    }

    public Boolean hasMinor(){
            return this.minor!=null;
    }

    public String getOp(){
            return this.op;
    }

    public A withOp(String op){
            this.op=op; return (A) this;
    }

    public Boolean hasOp(){
            return this.op!=null;
    }

    public Long getValue(){
            return this.value;
    }

    public A withValue(Long value){
            this.value=value; return (A) this;
    }

    public Boolean hasValue(){
            return this.value!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BlkioStatEntryFluentImpl that = (BlkioStatEntryFluentImpl) o;
            if (major != null ? !major.equals(that.major) :that.major != null) return false;
            if (minor != null ? !minor.equals(that.minor) :that.minor != null) return false;
            if (op != null ? !op.equals(that.op) :that.op != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }




}
