package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AuthResponseBuilder extends AuthResponseFluentImpl<AuthResponseBuilder> implements VisitableBuilder<AuthResponse,AuthResponseBuilder>{

    AuthResponseFluent<?> fluent;
    Boolean validationEnabled;

    public AuthResponseBuilder(){
            this(true);
    }
    public AuthResponseBuilder(Boolean validationEnabled){
            this(new AuthResponse(), validationEnabled);
    }
    public AuthResponseBuilder(AuthResponseFluent<?> fluent){
            this(fluent, true);
    }
    public AuthResponseBuilder(AuthResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AuthResponse(), validationEnabled);
    }
    public AuthResponseBuilder(AuthResponseFluent<?> fluent,AuthResponse instance){
            this(fluent, instance, true);
    }
    public AuthResponseBuilder(AuthResponseFluent<?> fluent,AuthResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthResponseBuilder(AuthResponse instance){
            this(instance,true);
    }
    public AuthResponseBuilder(AuthResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableAuthResponse build(){
            EditableAuthResponse buildable = new EditableAuthResponse(fluent.getStatus());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthResponseBuilder that = (AuthResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
