package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class VolumeFluentImpl<A extends VolumeFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements VolumeFluent<A>{

    private String Driver;
    private String Mountpoint;
    private String Name;

    public VolumeFluentImpl(){
    }
    public VolumeFluentImpl(Volume instance){
            this.withDriver(instance.getDriver()); 
            this.withMountpoint(instance.getMountpoint()); 
            this.withName(instance.getName()); 
    }

    public String getDriver(){
            return this.Driver;
    }

    public A withDriver(String Driver){
            this.Driver=Driver; return (A) this;
    }

    public Boolean hasDriver(){
            return this.Driver!=null;
    }

    public String getMountpoint(){
            return this.Mountpoint;
    }

    public A withMountpoint(String Mountpoint){
            this.Mountpoint=Mountpoint; return (A) this;
    }

    public Boolean hasMountpoint(){
            return this.Mountpoint!=null;
    }

    public String getName(){
            return this.Name;
    }

    public A withName(String Name){
            this.Name=Name; return (A) this;
    }

    public Boolean hasName(){
            return this.Name!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumeFluentImpl that = (VolumeFluentImpl) o;
            if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
            if (Mountpoint != null ? !Mountpoint.equals(that.Mountpoint) :that.Mountpoint != null) return false;
            if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
            return true;
    }




}
