package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface VersionFluent<A extends VersionFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String ApiVersion);
    public Boolean hasApiVersion();
    public String getArch();
    public A withArch(String Arch);
    public Boolean hasArch();
    public String getBuildTime();
    public A withBuildTime(String BuildTime);
    public Boolean hasBuildTime();
    public Boolean isExperimental();
    public A withExperimental(Boolean Experimental);
    public Boolean hasExperimental();
    public String getGitCommit();
    public A withGitCommit(String GitCommit);
    public Boolean hasGitCommit();
    public String getGoVersion();
    public A withGoVersion(String GoVersion);
    public Boolean hasGoVersion();
    public String getKernelVersion();
    public A withKernelVersion(String KernelVersion);
    public Boolean hasKernelVersion();
    public String getOs();
    public A withOs(String Os);
    public Boolean hasOs();
    public String getVersion();
    public A withVersion(String Version);
    public Boolean hasVersion();



}
