package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ThrottlingDataBuilder extends ThrottlingDataFluentImpl<ThrottlingDataBuilder> implements VisitableBuilder<ThrottlingData,ThrottlingDataBuilder>{

    ThrottlingDataFluent<?> fluent;
    Boolean validationEnabled;

    public ThrottlingDataBuilder(){
            this(true);
    }
    public ThrottlingDataBuilder(Boolean validationEnabled){
            this(new ThrottlingData(), validationEnabled);
    }
    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent){
            this(fluent, true);
    }
    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ThrottlingData(), validationEnabled);
    }
    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent,ThrottlingData instance){
            this(fluent, instance, true);
    }
    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent,ThrottlingData instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPeriods(instance.getPeriods()); 
            fluent.withThrottledPeriods(instance.getThrottledPeriods()); 
            fluent.withThrottledTime(instance.getThrottledTime()); 
            this.validationEnabled = validationEnabled; 
    }
    public ThrottlingDataBuilder(ThrottlingData instance){
            this(instance,true);
    }
    public ThrottlingDataBuilder(ThrottlingData instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPeriods(instance.getPeriods()); 
            this.withThrottledPeriods(instance.getThrottledPeriods()); 
            this.withThrottledTime(instance.getThrottledTime()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableThrottlingData build(){
            EditableThrottlingData buildable = new EditableThrottlingData(fluent.getPeriods(),fluent.getThrottledPeriods(),fluent.getThrottledTime());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ThrottlingDataBuilder that = (ThrottlingDataBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
