package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceConfigBuilder extends ServiceConfigFluentImpl<ServiceConfigBuilder> implements VisitableBuilder<ServiceConfig,ServiceConfigBuilder>{

    ServiceConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceConfigBuilder(){
            this(true);
    }
    public ServiceConfigBuilder(Boolean validationEnabled){
            this(new ServiceConfig(), validationEnabled);
    }
    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceConfig(), validationEnabled);
    }
    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent,ServiceConfig instance){
            this(fluent, instance, true);
    }
    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent,ServiceConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIndexConfigs(instance.getIndexConfigs()); 
            fluent.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs()); 
            fluent.withMirrors(instance.getMirrors()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceConfigBuilder(ServiceConfig instance){
            this(instance,true);
    }
    public ServiceConfigBuilder(ServiceConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIndexConfigs(instance.getIndexConfigs()); 
            this.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs()); 
            this.withMirrors(instance.getMirrors()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableServiceConfig build(){
            EditableServiceConfig buildable = new EditableServiceConfig(fluent.getIndexConfigs(),fluent.getInsecureRegistryCIDRs(),fluent.getMirrors());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceConfigBuilder that = (ServiceConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
