package io.fabric8.docker.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class RestartPolicyFluentImpl<A extends RestartPolicyFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements RestartPolicyFluent<A>{

    private Integer MaximumRetryCount;
    private String Name;

    public RestartPolicyFluentImpl(){
    }
    public RestartPolicyFluentImpl(RestartPolicy instance){
            this.withMaximumRetryCount(instance.getMaximumRetryCount()); 
            this.withName(instance.getName()); 
    }

    public Integer getMaximumRetryCount(){
            return this.MaximumRetryCount;
    }

    public A withMaximumRetryCount(Integer MaximumRetryCount){
            this.MaximumRetryCount=MaximumRetryCount; return (A) this;
    }

    public Boolean hasMaximumRetryCount(){
            return this.MaximumRetryCount!=null;
    }

    public String getName(){
            return this.Name;
    }

    public A withName(String Name){
            this.Name=Name; return (A) this;
    }

    public Boolean hasName(){
            return this.Name!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RestartPolicyFluentImpl that = (RestartPolicyFluentImpl) o;
            if (MaximumRetryCount != null ? !MaximumRetryCount.equals(that.MaximumRetryCount) :that.MaximumRetryCount != null) return false;
            if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
            return true;
    }




}
