package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PortBuilder extends PortFluentImpl<PortBuilder> implements VisitableBuilder<Port,PortBuilder>{

    PortFluent<?> fluent;
    Boolean validationEnabled;

    public PortBuilder(){
            this(true);
    }
    public PortBuilder(Boolean validationEnabled){
            this(new Port(), validationEnabled);
    }
    public PortBuilder(PortFluent<?> fluent){
            this(fluent, true);
    }
    public PortBuilder(PortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Port(), validationEnabled);
    }
    public PortBuilder(PortFluent<?> fluent,Port instance){
            this(fluent, instance, true);
    }
    public PortBuilder(PortFluent<?> fluent,Port instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIP(instance.getIP()); 
            fluent.withPrivatePort(instance.getPrivatePort()); 
            fluent.withPublicPort(instance.getPublicPort()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortBuilder(Port instance){
            this(instance,true);
    }
    public PortBuilder(Port instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIP(instance.getIP()); 
            this.withPrivatePort(instance.getPrivatePort()); 
            this.withPublicPort(instance.getPublicPort()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditablePort build(){
            EditablePort buildable = new EditablePort(fluent.getIP(),fluent.getPrivatePort(),fluent.getPublicPort(),fluent.getType());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PortBuilder that = (PortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
