package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class InfoFluentImpl<A extends InfoFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements InfoFluent<A>{

    private Boolean BridgeNfIp6tables;
    private Boolean BridgeNfIptables;
    private String ClusterAdvertise;
    private String ClusterStore;
    private Integer Containers;
    private Boolean CpuCfsPeriod;
    private Boolean CpuCfsQuota;
    private Boolean Debug;
    private String DockerRootDir;
    private String Driver;
    private List<Object> DriverStatus = new ArrayList<Object>();
    private String ExecutionDriver;
    private Boolean ExperimentalBuild;
    private String HttpProxy;
    private String HttpsProxy;
    private String ID;
    private Boolean IPv4Forwarding;
    private Integer Images;
    private String IndexServerAddress;
    private String InitPath;
    private String InitSha1;
    private String KernelVersion;
    private List<String> Labels = new ArrayList<String>();
    private String LoggingDriver;
    private Long MemTotal;
    private Boolean MemoryLimit;
    private Integer NCPU;
    private Integer NEventsListener;
    private Integer NFd;
    private Integer NGoroutines;
    private String Name;
    private String NoProxy;
    private Boolean OomKillDisable;
    private String OperatingSystem;
    private ServiceConfigBuilder RegistryConfig;
    private String ServerVersion;
    private Boolean SwapLimit;
    private String SystemTime;

    public InfoFluentImpl(){
    }
    public InfoFluentImpl(Info instance){
            this.withBridgeNfIp6tables(instance.getBridgeNfIp6tables()); 
            this.withBridgeNfIptables(instance.getBridgeNfIptables()); 
            this.withClusterAdvertise(instance.getClusterAdvertise()); 
            this.withClusterStore(instance.getClusterStore()); 
            this.withContainers(instance.getContainers()); 
            this.withCpuCfsPeriod(instance.getCpuCfsPeriod()); 
            this.withCpuCfsQuota(instance.getCpuCfsQuota()); 
            this.withDebug(instance.getDebug()); 
            this.withDockerRootDir(instance.getDockerRootDir()); 
            this.withDriver(instance.getDriver()); 
            this.withDriverStatus(instance.getDriverStatus()); 
            this.withExecutionDriver(instance.getExecutionDriver()); 
            this.withExperimentalBuild(instance.getExperimentalBuild()); 
            this.withHttpProxy(instance.getHttpProxy()); 
            this.withHttpsProxy(instance.getHttpsProxy()); 
            this.withID(instance.getID()); 
            this.withIPv4Forwarding(instance.getIPv4Forwarding()); 
            this.withImages(instance.getImages()); 
            this.withIndexServerAddress(instance.getIndexServerAddress()); 
            this.withInitPath(instance.getInitPath()); 
            this.withInitSha1(instance.getInitSha1()); 
            this.withKernelVersion(instance.getKernelVersion()); 
            this.withLabels(instance.getLabels()); 
            this.withLoggingDriver(instance.getLoggingDriver()); 
            this.withMemTotal(instance.getMemTotal()); 
            this.withMemoryLimit(instance.getMemoryLimit()); 
            this.withNCPU(instance.getNCPU()); 
            this.withNEventsListener(instance.getNEventsListener()); 
            this.withNFd(instance.getNFd()); 
            this.withNGoroutines(instance.getNGoroutines()); 
            this.withName(instance.getName()); 
            this.withNoProxy(instance.getNoProxy()); 
            this.withOomKillDisable(instance.getOomKillDisable()); 
            this.withOperatingSystem(instance.getOperatingSystem()); 
            this.withRegistryConfig(instance.getRegistryConfig()); 
            this.withServerVersion(instance.getServerVersion()); 
            this.withSwapLimit(instance.getSwapLimit()); 
            this.withSystemTime(instance.getSystemTime()); 
    }

    public Boolean isBridgeNfIp6tables(){
            return this.BridgeNfIp6tables;
    }

    public A withBridgeNfIp6tables(Boolean BridgeNfIp6tables){
            this.BridgeNfIp6tables=BridgeNfIp6tables; return (A) this;
    }

    public Boolean hasBridgeNfIp6tables(){
            return this.BridgeNfIp6tables!=null;
    }

    public Boolean isBridgeNfIptables(){
            return this.BridgeNfIptables;
    }

    public A withBridgeNfIptables(Boolean BridgeNfIptables){
            this.BridgeNfIptables=BridgeNfIptables; return (A) this;
    }

    public Boolean hasBridgeNfIptables(){
            return this.BridgeNfIptables!=null;
    }

    public String getClusterAdvertise(){
            return this.ClusterAdvertise;
    }

    public A withClusterAdvertise(String ClusterAdvertise){
            this.ClusterAdvertise=ClusterAdvertise; return (A) this;
    }

    public Boolean hasClusterAdvertise(){
            return this.ClusterAdvertise!=null;
    }

    public String getClusterStore(){
            return this.ClusterStore;
    }

    public A withClusterStore(String ClusterStore){
            this.ClusterStore=ClusterStore; return (A) this;
    }

    public Boolean hasClusterStore(){
            return this.ClusterStore!=null;
    }

    public Integer getContainers(){
            return this.Containers;
    }

    public A withContainers(Integer Containers){
            this.Containers=Containers; return (A) this;
    }

    public Boolean hasContainers(){
            return this.Containers!=null;
    }

    public Boolean isCpuCfsPeriod(){
            return this.CpuCfsPeriod;
    }

    public A withCpuCfsPeriod(Boolean CpuCfsPeriod){
            this.CpuCfsPeriod=CpuCfsPeriod; return (A) this;
    }

    public Boolean hasCpuCfsPeriod(){
            return this.CpuCfsPeriod!=null;
    }

    public Boolean isCpuCfsQuota(){
            return this.CpuCfsQuota;
    }

    public A withCpuCfsQuota(Boolean CpuCfsQuota){
            this.CpuCfsQuota=CpuCfsQuota; return (A) this;
    }

    public Boolean hasCpuCfsQuota(){
            return this.CpuCfsQuota!=null;
    }

    public Boolean isDebug(){
            return this.Debug;
    }

    public A withDebug(Boolean Debug){
            this.Debug=Debug; return (A) this;
    }

    public Boolean hasDebug(){
            return this.Debug!=null;
    }

    public String getDockerRootDir(){
            return this.DockerRootDir;
    }

    public A withDockerRootDir(String DockerRootDir){
            this.DockerRootDir=DockerRootDir; return (A) this;
    }

    public Boolean hasDockerRootDir(){
            return this.DockerRootDir!=null;
    }

    public String getDriver(){
            return this.Driver;
    }

    public A withDriver(String Driver){
            this.Driver=Driver; return (A) this;
    }

    public Boolean hasDriver(){
            return this.Driver!=null;
    }

    public A addToDriverStatus(int index,Object item){
            this.DriverStatus.add(index, item); return (A)this;
    }

    public A setToDriverStatus(int index,Object item){
            this.DriverStatus.set(index, item); return (A)this;
    }

    public A addToDriverStatus(Object... items){
            for (Object item : items) {this.DriverStatus.add(item);} return (A)this;
    }

    public A addAllToDriverStatus(Collection<Object> items){
            for (Object item : items) {this.DriverStatus.add(item);} return (A)this;
    }

    public A removeFromDriverStatus(Object... items){
            for (Object item : items) {this.DriverStatus.remove(item);} return (A)this;
    }

    public A removeAllFromDriverStatus(Collection<Object> items){
            for (Object item : items) {this.DriverStatus.remove(item);} return (A)this;
    }

    public List<Object> getDriverStatus(){
            return this.DriverStatus;
    }

    public Object getDriverStatus(int index){
            return this.DriverStatus.get(index);
    }

    public Object getFirstDriverStatus(){
            return this.DriverStatus.get(0);
    }

    public Object getLastDriverStatus(){
            return this.DriverStatus.get(DriverStatus.size() - 1);
    }

    public Object getMatchingDriverStatus(io.fabric8.docker.api.builder.Predicate<Object> predicate){
            for (Object item: DriverStatus) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withDriverStatus(List<Object> DriverStatus){
            this.DriverStatus.clear();
            if (DriverStatus != null) {for (Object item : DriverStatus){this.addToDriverStatus(item);}} return (A) this;
    }

    public A withDriverStatus(Object... DriverStatus){
            this.DriverStatus.clear(); if (DriverStatus != null) {for (Object item :DriverStatus){ this.addToDriverStatus(item);}} return (A) this;
    }

    public Boolean hasDriverStatus(){
            return DriverStatus!= null && !DriverStatus.isEmpty();
    }

    public String getExecutionDriver(){
            return this.ExecutionDriver;
    }

    public A withExecutionDriver(String ExecutionDriver){
            this.ExecutionDriver=ExecutionDriver; return (A) this;
    }

    public Boolean hasExecutionDriver(){
            return this.ExecutionDriver!=null;
    }

    public Boolean isExperimentalBuild(){
            return this.ExperimentalBuild;
    }

    public A withExperimentalBuild(Boolean ExperimentalBuild){
            this.ExperimentalBuild=ExperimentalBuild; return (A) this;
    }

    public Boolean hasExperimentalBuild(){
            return this.ExperimentalBuild!=null;
    }

    public String getHttpProxy(){
            return this.HttpProxy;
    }

    public A withHttpProxy(String HttpProxy){
            this.HttpProxy=HttpProxy; return (A) this;
    }

    public Boolean hasHttpProxy(){
            return this.HttpProxy!=null;
    }

    public String getHttpsProxy(){
            return this.HttpsProxy;
    }

    public A withHttpsProxy(String HttpsProxy){
            this.HttpsProxy=HttpsProxy; return (A) this;
    }

    public Boolean hasHttpsProxy(){
            return this.HttpsProxy!=null;
    }

    public String getID(){
            return this.ID;
    }

    public A withID(String ID){
            this.ID=ID; return (A) this;
    }

    public Boolean hasID(){
            return this.ID!=null;
    }

    public Boolean isIPv4Forwarding(){
            return this.IPv4Forwarding;
    }

    public A withIPv4Forwarding(Boolean IPv4Forwarding){
            this.IPv4Forwarding=IPv4Forwarding; return (A) this;
    }

    public Boolean hasIPv4Forwarding(){
            return this.IPv4Forwarding!=null;
    }

    public Integer getImages(){
            return this.Images;
    }

    public A withImages(Integer Images){
            this.Images=Images; return (A) this;
    }

    public Boolean hasImages(){
            return this.Images!=null;
    }

    public String getIndexServerAddress(){
            return this.IndexServerAddress;
    }

    public A withIndexServerAddress(String IndexServerAddress){
            this.IndexServerAddress=IndexServerAddress; return (A) this;
    }

    public Boolean hasIndexServerAddress(){
            return this.IndexServerAddress!=null;
    }

    public String getInitPath(){
            return this.InitPath;
    }

    public A withInitPath(String InitPath){
            this.InitPath=InitPath; return (A) this;
    }

    public Boolean hasInitPath(){
            return this.InitPath!=null;
    }

    public String getInitSha1(){
            return this.InitSha1;
    }

    public A withInitSha1(String InitSha1){
            this.InitSha1=InitSha1; return (A) this;
    }

    public Boolean hasInitSha1(){
            return this.InitSha1!=null;
    }

    public String getKernelVersion(){
            return this.KernelVersion;
    }

    public A withKernelVersion(String KernelVersion){
            this.KernelVersion=KernelVersion; return (A) this;
    }

    public Boolean hasKernelVersion(){
            return this.KernelVersion!=null;
    }

    public A addToLabels(int index,String item){
            this.Labels.add(index, item); return (A)this;
    }

    public A setToLabels(int index,String item){
            this.Labels.set(index, item); return (A)this;
    }

    public A addToLabels(String... items){
            for (String item : items) {this.Labels.add(item);} return (A)this;
    }

    public A addAllToLabels(Collection<String> items){
            for (String item : items) {this.Labels.add(item);} return (A)this;
    }

    public A removeFromLabels(String... items){
            for (String item : items) {this.Labels.remove(item);} return (A)this;
    }

    public A removeAllFromLabels(Collection<String> items){
            for (String item : items) {this.Labels.remove(item);} return (A)this;
    }

    public List<String> getLabels(){
            return this.Labels;
    }

    public String getLabel(int index){
            return this.Labels.get(index);
    }

    public String getFirstLabel(){
            return this.Labels.get(0);
    }

    public String getLastLabel(){
            return this.Labels.get(Labels.size() - 1);
    }

    public String getMatchingLabel(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Labels) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withLabels(List<String> Labels){
            this.Labels.clear();
            if (Labels != null) {for (String item : Labels){this.addToLabels(item);}} return (A) this;
    }

    public A withLabels(String... Labels){
            this.Labels.clear(); if (Labels != null) {for (String item :Labels){ this.addToLabels(item);}} return (A) this;
    }

    public Boolean hasLabels(){
            return Labels!= null && !Labels.isEmpty();
    }

    public String getLoggingDriver(){
            return this.LoggingDriver;
    }

    public A withLoggingDriver(String LoggingDriver){
            this.LoggingDriver=LoggingDriver; return (A) this;
    }

    public Boolean hasLoggingDriver(){
            return this.LoggingDriver!=null;
    }

    public Long getMemTotal(){
            return this.MemTotal;
    }

    public A withMemTotal(Long MemTotal){
            this.MemTotal=MemTotal; return (A) this;
    }

    public Boolean hasMemTotal(){
            return this.MemTotal!=null;
    }

    public Boolean isMemoryLimit(){
            return this.MemoryLimit;
    }

    public A withMemoryLimit(Boolean MemoryLimit){
            this.MemoryLimit=MemoryLimit; return (A) this;
    }

    public Boolean hasMemoryLimit(){
            return this.MemoryLimit!=null;
    }

    public Integer getNCPU(){
            return this.NCPU;
    }

    public A withNCPU(Integer NCPU){
            this.NCPU=NCPU; return (A) this;
    }

    public Boolean hasNCPU(){
            return this.NCPU!=null;
    }

    public Integer getNEventsListener(){
            return this.NEventsListener;
    }

    public A withNEventsListener(Integer NEventsListener){
            this.NEventsListener=NEventsListener; return (A) this;
    }

    public Boolean hasNEventsListener(){
            return this.NEventsListener!=null;
    }

    public Integer getNFd(){
            return this.NFd;
    }

    public A withNFd(Integer NFd){
            this.NFd=NFd; return (A) this;
    }

    public Boolean hasNFd(){
            return this.NFd!=null;
    }

    public Integer getNGoroutines(){
            return this.NGoroutines;
    }

    public A withNGoroutines(Integer NGoroutines){
            this.NGoroutines=NGoroutines; return (A) this;
    }

    public Boolean hasNGoroutines(){
            return this.NGoroutines!=null;
    }

    public String getName(){
            return this.Name;
    }

    public A withName(String Name){
            this.Name=Name; return (A) this;
    }

    public Boolean hasName(){
            return this.Name!=null;
    }

    public String getNoProxy(){
            return this.NoProxy;
    }

    public A withNoProxy(String NoProxy){
            this.NoProxy=NoProxy; return (A) this;
    }

    public Boolean hasNoProxy(){
            return this.NoProxy!=null;
    }

    public Boolean isOomKillDisable(){
            return this.OomKillDisable;
    }

    public A withOomKillDisable(Boolean OomKillDisable){
            this.OomKillDisable=OomKillDisable; return (A) this;
    }

    public Boolean hasOomKillDisable(){
            return this.OomKillDisable!=null;
    }

    public String getOperatingSystem(){
            return this.OperatingSystem;
    }

    public A withOperatingSystem(String OperatingSystem){
            this.OperatingSystem=OperatingSystem; return (A) this;
    }

    public Boolean hasOperatingSystem(){
            return this.OperatingSystem!=null;
    }

    
/**
 * This method has been deprecated, please use method buildRegistryConfig instead.
 */
@Deprecated public ServiceConfig getRegistryConfig(){
            return this.RegistryConfig!=null?this.RegistryConfig.build():null;
    }

    public ServiceConfig buildRegistryConfig(){
            return this.RegistryConfig!=null?this.RegistryConfig.build():null;
    }

    public A withRegistryConfig(ServiceConfig RegistryConfig){
            _visitables.remove(this.RegistryConfig);
            if (RegistryConfig!=null){ this.RegistryConfig= new ServiceConfigBuilder(RegistryConfig); _visitables.add(this.RegistryConfig);} return (A) this;
    }

    public Boolean hasRegistryConfig(){
            return this.RegistryConfig!=null;
    }

    public InfoFluent.RegistryConfigNested<A> withNewRegistryConfig(){
            return new RegistryConfigNestedImpl();
    }

    public InfoFluent.RegistryConfigNested<A> withNewRegistryConfigLike(ServiceConfig item){
            return new RegistryConfigNestedImpl(item);
    }

    public InfoFluent.RegistryConfigNested<A> editRegistryConfig(){
            return withNewRegistryConfigLike(getRegistryConfig());
    }

    public InfoFluent.RegistryConfigNested<A> editOrNewRegistryConfig(){
            return withNewRegistryConfigLike(getRegistryConfig() != null ? getRegistryConfig(): new ServiceConfigBuilder().build());
    }

    public InfoFluent.RegistryConfigNested<A> editOrNewRegistryConfigLike(ServiceConfig item){
            return withNewRegistryConfigLike(getRegistryConfig() != null ? getRegistryConfig(): item);
    }

    public String getServerVersion(){
            return this.ServerVersion;
    }

    public A withServerVersion(String ServerVersion){
            this.ServerVersion=ServerVersion; return (A) this;
    }

    public Boolean hasServerVersion(){
            return this.ServerVersion!=null;
    }

    public Boolean isSwapLimit(){
            return this.SwapLimit;
    }

    public A withSwapLimit(Boolean SwapLimit){
            this.SwapLimit=SwapLimit; return (A) this;
    }

    public Boolean hasSwapLimit(){
            return this.SwapLimit!=null;
    }

    public String getSystemTime(){
            return this.SystemTime;
    }

    public A withSystemTime(String SystemTime){
            this.SystemTime=SystemTime; return (A) this;
    }

    public Boolean hasSystemTime(){
            return this.SystemTime!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InfoFluentImpl that = (InfoFluentImpl) o;
            if (BridgeNfIp6tables != null ? !BridgeNfIp6tables.equals(that.BridgeNfIp6tables) :that.BridgeNfIp6tables != null) return false;
            if (BridgeNfIptables != null ? !BridgeNfIptables.equals(that.BridgeNfIptables) :that.BridgeNfIptables != null) return false;
            if (ClusterAdvertise != null ? !ClusterAdvertise.equals(that.ClusterAdvertise) :that.ClusterAdvertise != null) return false;
            if (ClusterStore != null ? !ClusterStore.equals(that.ClusterStore) :that.ClusterStore != null) return false;
            if (Containers != null ? !Containers.equals(that.Containers) :that.Containers != null) return false;
            if (CpuCfsPeriod != null ? !CpuCfsPeriod.equals(that.CpuCfsPeriod) :that.CpuCfsPeriod != null) return false;
            if (CpuCfsQuota != null ? !CpuCfsQuota.equals(that.CpuCfsQuota) :that.CpuCfsQuota != null) return false;
            if (Debug != null ? !Debug.equals(that.Debug) :that.Debug != null) return false;
            if (DockerRootDir != null ? !DockerRootDir.equals(that.DockerRootDir) :that.DockerRootDir != null) return false;
            if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
            if (DriverStatus != null ? !DriverStatus.equals(that.DriverStatus) :that.DriverStatus != null) return false;
            if (ExecutionDriver != null ? !ExecutionDriver.equals(that.ExecutionDriver) :that.ExecutionDriver != null) return false;
            if (ExperimentalBuild != null ? !ExperimentalBuild.equals(that.ExperimentalBuild) :that.ExperimentalBuild != null) return false;
            if (HttpProxy != null ? !HttpProxy.equals(that.HttpProxy) :that.HttpProxy != null) return false;
            if (HttpsProxy != null ? !HttpsProxy.equals(that.HttpsProxy) :that.HttpsProxy != null) return false;
            if (ID != null ? !ID.equals(that.ID) :that.ID != null) return false;
            if (IPv4Forwarding != null ? !IPv4Forwarding.equals(that.IPv4Forwarding) :that.IPv4Forwarding != null) return false;
            if (Images != null ? !Images.equals(that.Images) :that.Images != null) return false;
            if (IndexServerAddress != null ? !IndexServerAddress.equals(that.IndexServerAddress) :that.IndexServerAddress != null) return false;
            if (InitPath != null ? !InitPath.equals(that.InitPath) :that.InitPath != null) return false;
            if (InitSha1 != null ? !InitSha1.equals(that.InitSha1) :that.InitSha1 != null) return false;
            if (KernelVersion != null ? !KernelVersion.equals(that.KernelVersion) :that.KernelVersion != null) return false;
            if (Labels != null ? !Labels.equals(that.Labels) :that.Labels != null) return false;
            if (LoggingDriver != null ? !LoggingDriver.equals(that.LoggingDriver) :that.LoggingDriver != null) return false;
            if (MemTotal != null ? !MemTotal.equals(that.MemTotal) :that.MemTotal != null) return false;
            if (MemoryLimit != null ? !MemoryLimit.equals(that.MemoryLimit) :that.MemoryLimit != null) return false;
            if (NCPU != null ? !NCPU.equals(that.NCPU) :that.NCPU != null) return false;
            if (NEventsListener != null ? !NEventsListener.equals(that.NEventsListener) :that.NEventsListener != null) return false;
            if (NFd != null ? !NFd.equals(that.NFd) :that.NFd != null) return false;
            if (NGoroutines != null ? !NGoroutines.equals(that.NGoroutines) :that.NGoroutines != null) return false;
            if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
            if (NoProxy != null ? !NoProxy.equals(that.NoProxy) :that.NoProxy != null) return false;
            if (OomKillDisable != null ? !OomKillDisable.equals(that.OomKillDisable) :that.OomKillDisable != null) return false;
            if (OperatingSystem != null ? !OperatingSystem.equals(that.OperatingSystem) :that.OperatingSystem != null) return false;
            if (RegistryConfig != null ? !RegistryConfig.equals(that.RegistryConfig) :that.RegistryConfig != null) return false;
            if (ServerVersion != null ? !ServerVersion.equals(that.ServerVersion) :that.ServerVersion != null) return false;
            if (SwapLimit != null ? !SwapLimit.equals(that.SwapLimit) :that.SwapLimit != null) return false;
            if (SystemTime != null ? !SystemTime.equals(that.SystemTime) :that.SystemTime != null) return false;
            return true;
    }


    public class RegistryConfigNestedImpl<N> extends ServiceConfigFluentImpl<InfoFluent.RegistryConfigNested<N>> implements InfoFluent.RegistryConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ServiceConfigBuilder builder;
    
            RegistryConfigNestedImpl(ServiceConfig item){
                    this.builder = new ServiceConfigBuilder(this, item);
            }
            RegistryConfigNestedImpl(){
                    this.builder = new ServiceConfigBuilder(this);
            }
    
    public N and(){
            return (N) InfoFluentImpl.this.withRegistryConfig(builder.build());
    }
    public N endRegistryConfig(){
            return and();
    }

}


}
