package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InfoBuilder extends InfoFluentImpl<InfoBuilder> implements VisitableBuilder<Info,InfoBuilder>{

    InfoFluent<?> fluent;
    Boolean validationEnabled;

    public InfoBuilder(){
            this(true);
    }
    public InfoBuilder(Boolean validationEnabled){
            this(new Info(), validationEnabled);
    }
    public InfoBuilder(InfoFluent<?> fluent){
            this(fluent, true);
    }
    public InfoBuilder(InfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Info(), validationEnabled);
    }
    public InfoBuilder(InfoFluent<?> fluent,Info instance){
            this(fluent, instance, true);
    }
    public InfoBuilder(InfoFluent<?> fluent,Info instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBridgeNfIp6tables(instance.getBridgeNfIp6tables()); 
            fluent.withBridgeNfIptables(instance.getBridgeNfIptables()); 
            fluent.withClusterAdvertise(instance.getClusterAdvertise()); 
            fluent.withClusterStore(instance.getClusterStore()); 
            fluent.withContainers(instance.getContainers()); 
            fluent.withCpuCfsPeriod(instance.getCpuCfsPeriod()); 
            fluent.withCpuCfsQuota(instance.getCpuCfsQuota()); 
            fluent.withDebug(instance.getDebug()); 
            fluent.withDockerRootDir(instance.getDockerRootDir()); 
            fluent.withDriver(instance.getDriver()); 
            fluent.withDriverStatus(instance.getDriverStatus()); 
            fluent.withExecutionDriver(instance.getExecutionDriver()); 
            fluent.withExperimentalBuild(instance.getExperimentalBuild()); 
            fluent.withHttpProxy(instance.getHttpProxy()); 
            fluent.withHttpsProxy(instance.getHttpsProxy()); 
            fluent.withID(instance.getID()); 
            fluent.withIPv4Forwarding(instance.getIPv4Forwarding()); 
            fluent.withImages(instance.getImages()); 
            fluent.withIndexServerAddress(instance.getIndexServerAddress()); 
            fluent.withInitPath(instance.getInitPath()); 
            fluent.withInitSha1(instance.getInitSha1()); 
            fluent.withKernelVersion(instance.getKernelVersion()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withLoggingDriver(instance.getLoggingDriver()); 
            fluent.withMemTotal(instance.getMemTotal()); 
            fluent.withMemoryLimit(instance.getMemoryLimit()); 
            fluent.withNCPU(instance.getNCPU()); 
            fluent.withNEventsListener(instance.getNEventsListener()); 
            fluent.withNFd(instance.getNFd()); 
            fluent.withNGoroutines(instance.getNGoroutines()); 
            fluent.withName(instance.getName()); 
            fluent.withNoProxy(instance.getNoProxy()); 
            fluent.withOomKillDisable(instance.getOomKillDisable()); 
            fluent.withOperatingSystem(instance.getOperatingSystem()); 
            fluent.withRegistryConfig(instance.getRegistryConfig()); 
            fluent.withServerVersion(instance.getServerVersion()); 
            fluent.withSwapLimit(instance.getSwapLimit()); 
            fluent.withSystemTime(instance.getSystemTime()); 
            this.validationEnabled = validationEnabled; 
    }
    public InfoBuilder(Info instance){
            this(instance,true);
    }
    public InfoBuilder(Info instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBridgeNfIp6tables(instance.getBridgeNfIp6tables()); 
            this.withBridgeNfIptables(instance.getBridgeNfIptables()); 
            this.withClusterAdvertise(instance.getClusterAdvertise()); 
            this.withClusterStore(instance.getClusterStore()); 
            this.withContainers(instance.getContainers()); 
            this.withCpuCfsPeriod(instance.getCpuCfsPeriod()); 
            this.withCpuCfsQuota(instance.getCpuCfsQuota()); 
            this.withDebug(instance.getDebug()); 
            this.withDockerRootDir(instance.getDockerRootDir()); 
            this.withDriver(instance.getDriver()); 
            this.withDriverStatus(instance.getDriverStatus()); 
            this.withExecutionDriver(instance.getExecutionDriver()); 
            this.withExperimentalBuild(instance.getExperimentalBuild()); 
            this.withHttpProxy(instance.getHttpProxy()); 
            this.withHttpsProxy(instance.getHttpsProxy()); 
            this.withID(instance.getID()); 
            this.withIPv4Forwarding(instance.getIPv4Forwarding()); 
            this.withImages(instance.getImages()); 
            this.withIndexServerAddress(instance.getIndexServerAddress()); 
            this.withInitPath(instance.getInitPath()); 
            this.withInitSha1(instance.getInitSha1()); 
            this.withKernelVersion(instance.getKernelVersion()); 
            this.withLabels(instance.getLabels()); 
            this.withLoggingDriver(instance.getLoggingDriver()); 
            this.withMemTotal(instance.getMemTotal()); 
            this.withMemoryLimit(instance.getMemoryLimit()); 
            this.withNCPU(instance.getNCPU()); 
            this.withNEventsListener(instance.getNEventsListener()); 
            this.withNFd(instance.getNFd()); 
            this.withNGoroutines(instance.getNGoroutines()); 
            this.withName(instance.getName()); 
            this.withNoProxy(instance.getNoProxy()); 
            this.withOomKillDisable(instance.getOomKillDisable()); 
            this.withOperatingSystem(instance.getOperatingSystem()); 
            this.withRegistryConfig(instance.getRegistryConfig()); 
            this.withServerVersion(instance.getServerVersion()); 
            this.withSwapLimit(instance.getSwapLimit()); 
            this.withSystemTime(instance.getSystemTime()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableInfo build(){
            EditableInfo buildable = new EditableInfo(fluent.isBridgeNfIp6tables(),fluent.isBridgeNfIptables(),fluent.getClusterAdvertise(),fluent.getClusterStore(),fluent.getContainers(),fluent.isCpuCfsPeriod(),fluent.isCpuCfsQuota(),fluent.isDebug(),fluent.getDockerRootDir(),fluent.getDriver(),fluent.getDriverStatus(),fluent.getExecutionDriver(),fluent.isExperimentalBuild(),fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getID(),fluent.isIPv4Forwarding(),fluent.getImages(),fluent.getIndexServerAddress(),fluent.getInitPath(),fluent.getInitSha1(),fluent.getKernelVersion(),fluent.getLabels(),fluent.getLoggingDriver(),fluent.getMemTotal(),fluent.isMemoryLimit(),fluent.getNCPU(),fluent.getNEventsListener(),fluent.getNFd(),fluent.getNGoroutines(),fluent.getName(),fluent.getNoProxy(),fluent.isOomKillDisable(),fluent.getOperatingSystem(),fluent.getRegistryConfig(),fluent.getServerVersion(),fluent.isSwapLimit(),fluent.getSystemTime());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InfoBuilder that = (InfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
