package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.util.LinkedHashMap;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class ImageFluentImpl<A extends ImageFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ImageFluent<A>{

    private Long Created;
    private String Id;
    private Map<String,String> Labels = new LinkedHashMap<String,String>();
    private String ParentId;
    private List<String> RepoDigests = new ArrayList<String>();
    private List<String> RepoTags = new ArrayList<String>();
    private Long Size;
    private Long VirtualSize;

    public ImageFluentImpl(){
    }
    public ImageFluentImpl(Image instance){
            this.withCreated(instance.getCreated()); 
            this.withId(instance.getId()); 
            this.withLabels(instance.getLabels()); 
            this.withParentId(instance.getParentId()); 
            this.withRepoDigests(instance.getRepoDigests()); 
            this.withRepoTags(instance.getRepoTags()); 
            this.withSize(instance.getSize()); 
            this.withVirtualSize(instance.getVirtualSize()); 
    }

    public Long getCreated(){
            return this.Created;
    }

    public A withCreated(Long Created){
            this.Created=Created; return (A) this;
    }

    public Boolean hasCreated(){
            return this.Created!=null;
    }

    public String getId(){
            return this.Id;
    }

    public A withId(String Id){
            this.Id=Id; return (A) this;
    }

    public Boolean hasId(){
            return this.Id!=null;
    }

    public A addToLabels(String key,String value){
            if(key != null && value != null) {this.Labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(map != null) { this.Labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(key != null) {this.Labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.Labels.remove(key);}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.Labels;
    }

    public A withLabels(Map<String,String> Labels){
            this.Labels.clear();
            if (Labels != null) {this.Labels.putAll(Labels);} return (A) this;
    }

    public Boolean hasLabels(){
            return this.Labels!=null;
    }

    public String getParentId(){
            return this.ParentId;
    }

    public A withParentId(String ParentId){
            this.ParentId=ParentId; return (A) this;
    }

    public Boolean hasParentId(){
            return this.ParentId!=null;
    }

    public A addToRepoDigests(int index,String item){
            this.RepoDigests.add(index, item); return (A)this;
    }

    public A setToRepoDigests(int index,String item){
            this.RepoDigests.set(index, item); return (A)this;
    }

    public A addToRepoDigests(String... items){
            for (String item : items) {this.RepoDigests.add(item);} return (A)this;
    }

    public A addAllToRepoDigests(Collection<String> items){
            for (String item : items) {this.RepoDigests.add(item);} return (A)this;
    }

    public A removeFromRepoDigests(String... items){
            for (String item : items) {this.RepoDigests.remove(item);} return (A)this;
    }

    public A removeAllFromRepoDigests(Collection<String> items){
            for (String item : items) {this.RepoDigests.remove(item);} return (A)this;
    }

    public List<String> getRepoDigests(){
            return this.RepoDigests;
    }

    public String getRepoDigest(int index){
            return this.RepoDigests.get(index);
    }

    public String getFirstRepoDigest(){
            return this.RepoDigests.get(0);
    }

    public String getLastRepoDigest(){
            return this.RepoDigests.get(RepoDigests.size() - 1);
    }

    public String getMatchingRepoDigest(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: RepoDigests) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withRepoDigests(List<String> RepoDigests){
            this.RepoDigests.clear();
            if (RepoDigests != null) {for (String item : RepoDigests){this.addToRepoDigests(item);}} return (A) this;
    }

    public A withRepoDigests(String... RepoDigests){
            this.RepoDigests.clear(); if (RepoDigests != null) {for (String item :RepoDigests){ this.addToRepoDigests(item);}} return (A) this;
    }

    public Boolean hasRepoDigests(){
            return RepoDigests!= null && !RepoDigests.isEmpty();
    }

    public A addToRepoTags(int index,String item){
            this.RepoTags.add(index, item); return (A)this;
    }

    public A setToRepoTags(int index,String item){
            this.RepoTags.set(index, item); return (A)this;
    }

    public A addToRepoTags(String... items){
            for (String item : items) {this.RepoTags.add(item);} return (A)this;
    }

    public A addAllToRepoTags(Collection<String> items){
            for (String item : items) {this.RepoTags.add(item);} return (A)this;
    }

    public A removeFromRepoTags(String... items){
            for (String item : items) {this.RepoTags.remove(item);} return (A)this;
    }

    public A removeAllFromRepoTags(Collection<String> items){
            for (String item : items) {this.RepoTags.remove(item);} return (A)this;
    }

    public List<String> getRepoTags(){
            return this.RepoTags;
    }

    public String getRepoTag(int index){
            return this.RepoTags.get(index);
    }

    public String getFirstRepoTag(){
            return this.RepoTags.get(0);
    }

    public String getLastRepoTag(){
            return this.RepoTags.get(RepoTags.size() - 1);
    }

    public String getMatchingRepoTag(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: RepoTags) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withRepoTags(List<String> RepoTags){
            this.RepoTags.clear();
            if (RepoTags != null) {for (String item : RepoTags){this.addToRepoTags(item);}} return (A) this;
    }

    public A withRepoTags(String... RepoTags){
            this.RepoTags.clear(); if (RepoTags != null) {for (String item :RepoTags){ this.addToRepoTags(item);}} return (A) this;
    }

    public Boolean hasRepoTags(){
            return RepoTags!= null && !RepoTags.isEmpty();
    }

    public Long getSize(){
            return this.Size;
    }

    public A withSize(Long Size){
            this.Size=Size; return (A) this;
    }

    public Boolean hasSize(){
            return this.Size!=null;
    }

    public Long getVirtualSize(){
            return this.VirtualSize;
    }

    public A withVirtualSize(Long VirtualSize){
            this.VirtualSize=VirtualSize; return (A) this;
    }

    public Boolean hasVirtualSize(){
            return this.VirtualSize!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageFluentImpl that = (ImageFluentImpl) o;
            if (Created != null ? !Created.equals(that.Created) :that.Created != null) return false;
            if (Id != null ? !Id.equals(that.Id) :that.Id != null) return false;
            if (Labels != null ? !Labels.equals(that.Labels) :that.Labels != null) return false;
            if (ParentId != null ? !ParentId.equals(that.ParentId) :that.ParentId != null) return false;
            if (RepoDigests != null ? !RepoDigests.equals(that.RepoDigests) :that.RepoDigests != null) return false;
            if (RepoTags != null ? !RepoTags.equals(that.RepoTags) :that.RepoTags != null) return false;
            if (Size != null ? !Size.equals(that.Size) :that.Size != null) return false;
            if (VirtualSize != null ? !VirtualSize.equals(that.VirtualSize) :that.VirtualSize != null) return false;
            return true;
    }




}
