package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageDeleteBuilder extends ImageDeleteFluentImpl<ImageDeleteBuilder> implements VisitableBuilder<ImageDelete,ImageDeleteBuilder>{

    ImageDeleteFluent<?> fluent;
    Boolean validationEnabled;

    public ImageDeleteBuilder(){
            this(true);
    }
    public ImageDeleteBuilder(Boolean validationEnabled){
            this(new ImageDelete(), validationEnabled);
    }
    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent){
            this(fluent, true);
    }
    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageDelete(), validationEnabled);
    }
    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent,ImageDelete instance){
            this(fluent, instance, true);
    }
    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent,ImageDelete instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDeleted(instance.getDeleted()); 
            fluent.withUntagged(instance.getUntagged()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageDeleteBuilder(ImageDelete instance){
            this(instance,true);
    }
    public ImageDeleteBuilder(ImageDelete instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDeleted(instance.getDeleted()); 
            this.withUntagged(instance.getUntagged()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableImageDelete build(){
            EditableImageDelete buildable = new EditableImageDelete(fluent.getDeleted(),fluent.getUntagged());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageDeleteBuilder that = (ImageDeleteBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
