package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointResourceBuilder extends EndpointResourceFluentImpl<EndpointResourceBuilder> implements VisitableBuilder<EndpointResource,EndpointResourceBuilder>{

    EndpointResourceFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointResourceBuilder(){
            this(true);
    }
    public EndpointResourceBuilder(Boolean validationEnabled){
            this(new EndpointResource(), validationEnabled);
    }
    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent){
            this(fluent, true);
    }
    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EndpointResource(), validationEnabled);
    }
    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent,EndpointResource instance){
            this(fluent, instance, true);
    }
    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent,EndpointResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEndpointID(instance.getEndpointID()); 
            fluent.withIPv4Address(instance.getIPv4Address()); 
            fluent.withIPv6Address(instance.getIPv6Address()); 
            fluent.withMacAddress(instance.getMacAddress()); 
            this.validationEnabled = validationEnabled; 
    }
    public EndpointResourceBuilder(EndpointResource instance){
            this(instance,true);
    }
    public EndpointResourceBuilder(EndpointResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEndpointID(instance.getEndpointID()); 
            this.withIPv4Address(instance.getIPv4Address()); 
            this.withIPv6Address(instance.getIPv6Address()); 
            this.withMacAddress(instance.getMacAddress()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableEndpointResource build(){
            EditableEndpointResource buildable = new EditableEndpointResource(fluent.getEndpointID(),fluent.getIPv4Address(),fluent.getIPv6Address(),fluent.getMacAddress());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointResourceBuilder that = (EndpointResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
