package io.fabric8.docker.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ContainerStateFluentImpl<A extends ContainerStateFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ContainerStateFluent<A>{

    private Boolean Dead;
    private String Error;
    private Integer ExitCode;
    private String FinishedAt;
    private Boolean OOMKilled;
    private Boolean Paused;
    private Integer Pid;
    private Boolean Restarting;
    private Boolean Running;
    private String StartedAt;
    private String Status;

    public ContainerStateFluentImpl(){
    }
    public ContainerStateFluentImpl(ContainerState instance){
            this.withDead(instance.getDead()); 
            this.withError(instance.getError()); 
            this.withExitCode(instance.getExitCode()); 
            this.withFinishedAt(instance.getFinishedAt()); 
            this.withOOMKilled(instance.getOOMKilled()); 
            this.withPaused(instance.getPaused()); 
            this.withPid(instance.getPid()); 
            this.withRestarting(instance.getRestarting()); 
            this.withRunning(instance.getRunning()); 
            this.withStartedAt(instance.getStartedAt()); 
            this.withStatus(instance.getStatus()); 
    }

    public Boolean isDead(){
            return this.Dead;
    }

    public A withDead(Boolean Dead){
            this.Dead=Dead; return (A) this;
    }

    public Boolean hasDead(){
            return this.Dead!=null;
    }

    public String getError(){
            return this.Error;
    }

    public A withError(String Error){
            this.Error=Error; return (A) this;
    }

    public Boolean hasError(){
            return this.Error!=null;
    }

    public Integer getExitCode(){
            return this.ExitCode;
    }

    public A withExitCode(Integer ExitCode){
            this.ExitCode=ExitCode; return (A) this;
    }

    public Boolean hasExitCode(){
            return this.ExitCode!=null;
    }

    public String getFinishedAt(){
            return this.FinishedAt;
    }

    public A withFinishedAt(String FinishedAt){
            this.FinishedAt=FinishedAt; return (A) this;
    }

    public Boolean hasFinishedAt(){
            return this.FinishedAt!=null;
    }

    public Boolean isOOMKilled(){
            return this.OOMKilled;
    }

    public A withOOMKilled(Boolean OOMKilled){
            this.OOMKilled=OOMKilled; return (A) this;
    }

    public Boolean hasOOMKilled(){
            return this.OOMKilled!=null;
    }

    public Boolean isPaused(){
            return this.Paused;
    }

    public A withPaused(Boolean Paused){
            this.Paused=Paused; return (A) this;
    }

    public Boolean hasPaused(){
            return this.Paused!=null;
    }

    public Integer getPid(){
            return this.Pid;
    }

    public A withPid(Integer Pid){
            this.Pid=Pid; return (A) this;
    }

    public Boolean hasPid(){
            return this.Pid!=null;
    }

    public Boolean isRestarting(){
            return this.Restarting;
    }

    public A withRestarting(Boolean Restarting){
            this.Restarting=Restarting; return (A) this;
    }

    public Boolean hasRestarting(){
            return this.Restarting!=null;
    }

    public Boolean isRunning(){
            return this.Running;
    }

    public A withRunning(Boolean Running){
            this.Running=Running; return (A) this;
    }

    public Boolean hasRunning(){
            return this.Running!=null;
    }

    public String getStartedAt(){
            return this.StartedAt;
    }

    public A withStartedAt(String StartedAt){
            this.StartedAt=StartedAt; return (A) this;
    }

    public Boolean hasStartedAt(){
            return this.StartedAt!=null;
    }

    public String getStatus(){
            return this.Status;
    }

    public A withStatus(String Status){
            this.Status=Status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.Status!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerStateFluentImpl that = (ContainerStateFluentImpl) o;
            if (Dead != null ? !Dead.equals(that.Dead) :that.Dead != null) return false;
            if (Error != null ? !Error.equals(that.Error) :that.Error != null) return false;
            if (ExitCode != null ? !ExitCode.equals(that.ExitCode) :that.ExitCode != null) return false;
            if (FinishedAt != null ? !FinishedAt.equals(that.FinishedAt) :that.FinishedAt != null) return false;
            if (OOMKilled != null ? !OOMKilled.equals(that.OOMKilled) :that.OOMKilled != null) return false;
            if (Paused != null ? !Paused.equals(that.Paused) :that.Paused != null) return false;
            if (Pid != null ? !Pid.equals(that.Pid) :that.Pid != null) return false;
            if (Restarting != null ? !Restarting.equals(that.Restarting) :that.Restarting != null) return false;
            if (Running != null ? !Running.equals(that.Running) :that.Running != null) return false;
            if (StartedAt != null ? !StartedAt.equals(that.StartedAt) :that.StartedAt != null) return false;
            if (Status != null ? !Status.equals(that.Status) :that.Status != null) return false;
            return true;
    }




}
