package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ContainerProcessListFluentImpl<A extends ContainerProcessListFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ContainerProcessListFluent<A>{

    private List<List<String>> Processes = new ArrayList<List<String>>();
    private List<String> Titles = new ArrayList<String>();

    public ContainerProcessListFluentImpl(){
    }
    public ContainerProcessListFluentImpl(ContainerProcessList instance){
            this.withProcesses(instance.getProcesses()); 
            this.withTitles(instance.getTitles()); 
    }

    public A addToProcesses(int index,List<String> item){
            this.Processes.add(index, item); return (A)this;
    }

    public A setToProcesses(int index,List<String> item){
            this.Processes.set(index, item); return (A)this;
    }

    public A addToProcesses(List<String>... items){
            for (List<String> item : items) {this.Processes.add(item);} return (A)this;
    }

    public A addAllToProcesses(Collection<List<String>> items){
            for (List<String> item : items) {this.Processes.add(item);} return (A)this;
    }

    public A removeFromProcesses(List<String>... items){
            for (List<String> item : items) {this.Processes.remove(item);} return (A)this;
    }

    public A removeAllFromProcesses(Collection<List<String>> items){
            for (List<String> item : items) {this.Processes.remove(item);} return (A)this;
    }

    public List<List<String>> getProcesses(){
            return this.Processes;
    }

    public List<String> getProcess(int index){
            return this.Processes.get(index);
    }

    public List<String> getFirstProcess(){
            return this.Processes.get(0);
    }

    public List<String> getLastProcess(){
            return this.Processes.get(Processes.size() - 1);
    }

    public List<String> getMatchingProcess(io.fabric8.docker.api.builder.Predicate<List<String>> predicate){
            for (List<String> item: Processes) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withProcesses(List<List<String>> Processes){
            this.Processes.clear();
            if (Processes != null) {for (List<String> item : Processes){this.addToProcesses(item);}} return (A) this;
    }

    public A withProcesses(List<String>... Processes){
            this.Processes.clear(); if (Processes != null) {for (List<String> item :Processes){ this.addToProcesses(item);}} return (A) this;
    }

    public Boolean hasProcesses(){
            return Processes!= null && !Processes.isEmpty();
    }

    public A addToTitles(int index,String item){
            this.Titles.add(index, item); return (A)this;
    }

    public A setToTitles(int index,String item){
            this.Titles.set(index, item); return (A)this;
    }

    public A addToTitles(String... items){
            for (String item : items) {this.Titles.add(item);} return (A)this;
    }

    public A addAllToTitles(Collection<String> items){
            for (String item : items) {this.Titles.add(item);} return (A)this;
    }

    public A removeFromTitles(String... items){
            for (String item : items) {this.Titles.remove(item);} return (A)this;
    }

    public A removeAllFromTitles(Collection<String> items){
            for (String item : items) {this.Titles.remove(item);} return (A)this;
    }

    public List<String> getTitles(){
            return this.Titles;
    }

    public String getTitle(int index){
            return this.Titles.get(index);
    }

    public String getFirstTitle(){
            return this.Titles.get(0);
    }

    public String getLastTitle(){
            return this.Titles.get(Titles.size() - 1);
    }

    public String getMatchingTitle(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Titles) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withTitles(List<String> Titles){
            this.Titles.clear();
            if (Titles != null) {for (String item : Titles){this.addToTitles(item);}} return (A) this;
    }

    public A withTitles(String... Titles){
            this.Titles.clear(); if (Titles != null) {for (String item :Titles){ this.addToTitles(item);}} return (A) this;
    }

    public Boolean hasTitles(){
            return Titles!= null && !Titles.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerProcessListFluentImpl that = (ContainerProcessListFluentImpl) o;
            if (Processes != null ? !Processes.equals(that.Processes) :that.Processes != null) return false;
            if (Titles != null ? !Titles.equals(that.Titles) :that.Titles != null) return false;
            return true;
    }




}
