package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ContainerHostConfigFluentImpl<A extends ContainerHostConfigFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ContainerHostConfigFluent<A>{

    private String networkMode;

    public ContainerHostConfigFluentImpl(){
    }
    public ContainerHostConfigFluentImpl(ContainerHostConfig instance){
            this.withNetworkMode(instance.getNetworkMode()); 
    }

    public String getNetworkMode(){
            return this.networkMode;
    }

    public A withNetworkMode(String networkMode){
            this.networkMode=networkMode; return (A) this;
    }

    public Boolean hasNetworkMode(){
            return this.networkMode!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerHostConfigFluentImpl that = (ContainerHostConfigFluentImpl) o;
            if (networkMode != null ? !networkMode.equals(that.networkMode) :that.networkMode != null) return false;
            return true;
    }




}
