package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerExecCreateResponseBuilder extends ContainerExecCreateResponseFluentImpl<ContainerExecCreateResponseBuilder> implements VisitableBuilder<ContainerExecCreateResponse,ContainerExecCreateResponseBuilder>{

    ContainerExecCreateResponseFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerExecCreateResponseBuilder(){
            this(true);
    }
    public ContainerExecCreateResponseBuilder(Boolean validationEnabled){
            this(new ContainerExecCreateResponse(), validationEnabled);
    }
    public ContainerExecCreateResponseBuilder(ContainerExecCreateResponseFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerExecCreateResponseBuilder(ContainerExecCreateResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerExecCreateResponse(), validationEnabled);
    }
    public ContainerExecCreateResponseBuilder(ContainerExecCreateResponseFluent<?> fluent,ContainerExecCreateResponse instance){
            this(fluent, instance, true);
    }
    public ContainerExecCreateResponseBuilder(ContainerExecCreateResponseFluent<?> fluent,ContainerExecCreateResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withId(instance.getId()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerExecCreateResponseBuilder(ContainerExecCreateResponse instance){
            this(instance,true);
    }
    public ContainerExecCreateResponseBuilder(ContainerExecCreateResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withId(instance.getId()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerExecCreateResponse build(){
            EditableContainerExecCreateResponse buildable = new EditableContainerExecCreateResponse(fluent.getId());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerExecCreateResponseBuilder that = (ContainerExecCreateResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
