package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerCommitResponseBuilder extends ContainerCommitResponseFluentImpl<ContainerCommitResponseBuilder> implements VisitableBuilder<ContainerCommitResponse,ContainerCommitResponseBuilder>{

    ContainerCommitResponseFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerCommitResponseBuilder(){
            this(true);
    }
    public ContainerCommitResponseBuilder(Boolean validationEnabled){
            this(new ContainerCommitResponse(), validationEnabled);
    }
    public ContainerCommitResponseBuilder(ContainerCommitResponseFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerCommitResponseBuilder(ContainerCommitResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerCommitResponse(), validationEnabled);
    }
    public ContainerCommitResponseBuilder(ContainerCommitResponseFluent<?> fluent,ContainerCommitResponse instance){
            this(fluent, instance, true);
    }
    public ContainerCommitResponseBuilder(ContainerCommitResponseFluent<?> fluent,ContainerCommitResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withId(instance.getId()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerCommitResponseBuilder(ContainerCommitResponse instance){
            this(instance,true);
    }
    public ContainerCommitResponseBuilder(ContainerCommitResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withId(instance.getId()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerCommitResponse build(){
            EditableContainerCommitResponse buildable = new EditableContainerCommitResponse(fluent.getId());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerCommitResponseBuilder that = (ContainerCommitResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
