package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CPUUsageFluent<A extends CPUUsageFluent<A>> extends Fluent<A>{


    public A addToPercpuUsage(int index,Long item);
    public A setToPercpuUsage(int index,Long item);
    public A addToPercpuUsage(Long... items);
    public A addAllToPercpuUsage(Collection<Long> items);
    public A removeFromPercpuUsage(Long... items);
    public A removeAllFromPercpuUsage(Collection<Long> items);
    public List<Long> getPercpuUsage();
    public Long getPercpuUsage(int index);
    public Long getFirstPercpuUsage();
    public Long getLastPercpuUsage();
    public Long getMatchingPercpuUsage(io.fabric8.docker.api.builder.Predicate<Long> predicate);
    public A withPercpuUsage(List<Long> percpuUsage);
    public A withPercpuUsage(Long... percpuUsage);
    public Boolean hasPercpuUsage();
    public Long getTotalUsage();
    public A withTotalUsage(Long totalUsage);
    public Boolean hasTotalUsage();
    public Long getUsageInKernelmode();
    public A withUsageInKernelmode(Long usageInKernelmode);
    public Boolean hasUsageInKernelmode();
    public Long getUsageInUsermode();
    public A withUsageInUsermode(Long usageInUsermode);
    public Boolean hasUsageInUsermode();



}
