package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CPUUsageBuilder extends CPUUsageFluentImpl<CPUUsageBuilder> implements VisitableBuilder<CPUUsage,CPUUsageBuilder>{

    CPUUsageFluent<?> fluent;
    Boolean validationEnabled;

    public CPUUsageBuilder(){
            this(true);
    }
    public CPUUsageBuilder(Boolean validationEnabled){
            this(new CPUUsage(), validationEnabled);
    }
    public CPUUsageBuilder(CPUUsageFluent<?> fluent){
            this(fluent, true);
    }
    public CPUUsageBuilder(CPUUsageFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CPUUsage(), validationEnabled);
    }
    public CPUUsageBuilder(CPUUsageFluent<?> fluent,CPUUsage instance){
            this(fluent, instance, true);
    }
    public CPUUsageBuilder(CPUUsageFluent<?> fluent,CPUUsage instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPercpuUsage(instance.getPercpuUsage()); 
            fluent.withTotalUsage(instance.getTotalUsage()); 
            fluent.withUsageInKernelmode(instance.getUsageInKernelmode()); 
            fluent.withUsageInUsermode(instance.getUsageInUsermode()); 
            this.validationEnabled = validationEnabled; 
    }
    public CPUUsageBuilder(CPUUsage instance){
            this(instance,true);
    }
    public CPUUsageBuilder(CPUUsage instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPercpuUsage(instance.getPercpuUsage()); 
            this.withTotalUsage(instance.getTotalUsage()); 
            this.withUsageInKernelmode(instance.getUsageInKernelmode()); 
            this.withUsageInUsermode(instance.getUsageInUsermode()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableCPUUsage build(){
            EditableCPUUsage buildable = new EditableCPUUsage(fluent.getPercpuUsage(),fluent.getTotalUsage(),fluent.getUsageInKernelmode(),fluent.getUsageInUsermode());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CPUUsageBuilder that = (CPUUsageBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
