/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.Volume;
import io.fabric8.docker.api.model.VolumeBuilder;
import io.fabric8.docker.api.model.VolumeFluentImpl;
import io.fabric8.docker.api.model.VolumesListResponse;
import io.fabric8.docker.api.model.VolumesListResponseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VolumesListResponseFluentImpl<A extends VolumesListResponseFluent<A>>
extends BaseFluent<A>
implements VolumesListResponseFluent<A> {
    private List<VolumeBuilder> Volumes = new ArrayList<VolumeBuilder>();

    public VolumesListResponseFluentImpl() {
    }

    public VolumesListResponseFluentImpl(VolumesListResponse instance) {
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.Volumes.add(index >= 0 ? index : this.Volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.Volumes.size()) {
            this.Volumes.add(builder);
        } else {
            this.Volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.add(builder);
            this.Volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.add(builder);
            this.Volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.remove(builder);
            this.Volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.remove(builder);
            this.Volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return VolumesListResponseFluentImpl.build(this.Volumes);
    }

    @Override
    public List<Volume> buildVolumes() {
        return VolumesListResponseFluentImpl.build(this.Volumes);
    }

    @Override
    public Volume buildVolume(int index) {
        return this.Volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.Volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.Volumes.get(this.Volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.Volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withVolumes(List<Volume> Volumes) {
        this._visitables.removeAll(this.Volumes);
        this.Volumes.clear();
        if (Volumes != null) {
            for (Volume item : Volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... Volumes) {
        this.Volumes.clear();
        if (Volumes != null) {
            for (Volume item : Volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.Volumes != null && !this.Volumes.isEmpty();
    }

    @Override
    public VolumesListResponseFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public VolumesListResponseFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public VolumesListResponseFluent.VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public VolumesListResponseFluent.VolumesNested<A> editVolume(int index) {
        if (this.Volumes.size() <= index) {
            throw new RuntimeException("Can't edit Volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public VolumesListResponseFluent.VolumesNested<A> editFirstVolume() {
        if (this.Volumes.size() == 0) {
            throw new RuntimeException("Can't edit first Volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public VolumesListResponseFluent.VolumesNested<A> editLastVolume() {
        int index = this.Volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last Volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public VolumesListResponseFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.Volumes.size(); ++i) {
            if (!predicate.apply(this.Volumes.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching Volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public A addNewVolume(String Driver, String Mountpoint, String Name) {
        return this.addToVolumes(new Volume(Driver, Mountpoint, Name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumesListResponseFluentImpl that = (VolumesListResponseFluentImpl)o;
        return !(this.Volumes != null ? !this.Volumes.equals(that.Volumes) : that.Volumes != null);
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<VolumesListResponseFluent.VolumesNested<N>>
    implements VolumesListResponseFluent.VolumesNested<N>,
    Nested<N> {
        private final VolumeBuilder builder;
        private final int index;

        VolumesNestedImpl(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumesListResponseFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }
}

