/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableServiceConfig;
import io.fabric8.docker.api.model.ServiceConfig;
import io.fabric8.docker.api.model.ServiceConfigFluent;
import io.fabric8.docker.api.model.ServiceConfigFluentImpl;

public class ServiceConfigBuilder
extends ServiceConfigFluentImpl<ServiceConfigBuilder>
implements VisitableBuilder<ServiceConfig, ServiceConfigBuilder> {
    ServiceConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceConfigBuilder() {
        this(true);
    }

    public ServiceConfigBuilder(Boolean validationEnabled) {
        this(new ServiceConfig(), validationEnabled);
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceConfig(), validationEnabled);
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent, ServiceConfig instance) {
        this(fluent, instance, true);
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent, ServiceConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIndexConfigs(instance.getIndexConfigs());
        fluent.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs());
        fluent.withMirrors(instance.getMirrors());
        this.validationEnabled = validationEnabled;
    }

    public ServiceConfigBuilder(ServiceConfig instance) {
        this(instance, (Boolean)true);
    }

    public ServiceConfigBuilder(ServiceConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIndexConfigs(instance.getIndexConfigs());
        this.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs());
        this.withMirrors(instance.getMirrors());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableServiceConfig build() {
        EditableServiceConfig buildable = new EditableServiceConfig(this.fluent.getIndexConfigs(), this.fluent.getInsecureRegistryCIDRs(), this.fluent.getMirrors());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceConfigBuilder that = (ServiceConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

