/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.SearchResult;
import io.fabric8.docker.api.model.SearchResultBuilder;
import io.fabric8.docker.api.model.SearchResultFluentImpl;
import io.fabric8.docker.api.model.SearchResults;
import io.fabric8.docker.api.model.SearchResultsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchResultsFluentImpl<A extends SearchResultsFluent<A>>
extends BaseFluent<A>
implements SearchResultsFluent<A> {
    private Integer numResults;
    private String query;
    private List<SearchResultBuilder> results = new ArrayList<SearchResultBuilder>();

    public SearchResultsFluentImpl() {
    }

    public SearchResultsFluentImpl(SearchResults instance) {
        this.withNumResults(instance.getNumResults());
        this.withQuery(instance.getQuery());
        this.withResults(instance.getResults());
    }

    @Override
    public Integer getNumResults() {
        return this.numResults;
    }

    @Override
    public A withNumResults(Integer numResults) {
        this.numResults = numResults;
        return (A)this;
    }

    @Override
    public Boolean hasNumResults() {
        return this.numResults != null;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public A withQuery(String query) {
        this.query = query;
        return (A)this;
    }

    @Override
    public Boolean hasQuery() {
        return this.query != null;
    }

    @Override
    public A addToResults(int index, SearchResult item) {
        SearchResultBuilder builder = new SearchResultBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.results.add(index >= 0 ? index : this.results.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResults(int index, SearchResult item) {
        SearchResultBuilder builder = new SearchResultBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.results.size()) {
            this.results.add(builder);
        } else {
            this.results.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResults(SearchResult ... items) {
        for (SearchResult item : items) {
            SearchResultBuilder builder = new SearchResultBuilder(item);
            this._visitables.add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResults(Collection<SearchResult> items) {
        for (SearchResult item : items) {
            SearchResultBuilder builder = new SearchResultBuilder(item);
            this._visitables.add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResults(SearchResult ... items) {
        for (SearchResult item : items) {
            SearchResultBuilder builder = new SearchResultBuilder(item);
            this._visitables.remove(builder);
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResults(Collection<SearchResult> items) {
        for (SearchResult item : items) {
            SearchResultBuilder builder = new SearchResultBuilder(item);
            this._visitables.remove(builder);
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SearchResult> getResults() {
        return SearchResultsFluentImpl.build(this.results);
    }

    @Override
    public List<SearchResult> buildResults() {
        return SearchResultsFluentImpl.build(this.results);
    }

    @Override
    public SearchResult buildResult(int index) {
        return this.results.get(index).build();
    }

    @Override
    public SearchResult buildFirstResult() {
        return this.results.get(0).build();
    }

    @Override
    public SearchResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    @Override
    public SearchResult buildMatchingResult(Predicate<SearchResultBuilder> predicate) {
        for (SearchResultBuilder item : this.results) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withResults(List<SearchResult> results) {
        this._visitables.removeAll(this.results);
        this.results.clear();
        if (results != null) {
            for (SearchResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withResults(SearchResult ... results) {
        this.results.clear();
        if (results != null) {
            for (SearchResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    @Override
    public SearchResultsFluent.ResultsNested<A> addNewResult() {
        return new ResultsNestedImpl();
    }

    @Override
    public SearchResultsFluent.ResultsNested<A> addNewResultLike(SearchResult item) {
        return new ResultsNestedImpl(-1, item);
    }

    @Override
    public SearchResultsFluent.ResultsNested<A> setNewResultLike(int index, SearchResult item) {
        return new ResultsNestedImpl(index, item);
    }

    @Override
    public SearchResultsFluent.ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException("Can't edit results. Index exceeds size.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public SearchResultsFluent.ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException("Can't edit first results. The list is empty.");
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    @Override
    public SearchResultsFluent.ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last results. The list is empty.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public SearchResultsFluent.ResultsNested<A> editMatchingResult(Predicate<SearchResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.apply(this.results.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching results. No match found.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchResultsFluentImpl that = (SearchResultsFluentImpl)o;
        if (this.numResults != null ? !this.numResults.equals(that.numResults) : that.numResults != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        return !(this.results != null ? !this.results.equals(that.results) : that.results != null);
    }

    public class ResultsNestedImpl<N>
    extends SearchResultFluentImpl<SearchResultsFluent.ResultsNested<N>>
    implements SearchResultsFluent.ResultsNested<N>,
    Nested<N> {
        private final SearchResultBuilder builder;
        private final int index;

        ResultsNestedImpl(int index, SearchResult item) {
            this.index = index;
            this.builder = new SearchResultBuilder(this, item);
        }

        ResultsNestedImpl() {
            this.index = -1;
            this.builder = new SearchResultBuilder(this);
        }

        @Override
        public N and() {
            return (N)SearchResultsFluentImpl.this.setToResults(this.index, this.builder.build());
        }

        @Override
        public N endResult() {
            return this.and();
        }
    }
}

