/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableMountPoint;
import io.fabric8.docker.api.model.MountPoint;
import io.fabric8.docker.api.model.MountPointFluent;
import io.fabric8.docker.api.model.MountPointFluentImpl;

public class MountPointBuilder
extends MountPointFluentImpl<MountPointBuilder>
implements VisitableBuilder<MountPoint, MountPointBuilder> {
    MountPointFluent<?> fluent;
    Boolean validationEnabled;

    public MountPointBuilder() {
        this(true);
    }

    public MountPointBuilder(Boolean validationEnabled) {
        this(new MountPoint(), validationEnabled);
    }

    public MountPointBuilder(MountPointFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MountPointBuilder(MountPointFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MountPoint(), validationEnabled);
    }

    public MountPointBuilder(MountPointFluent<?> fluent, MountPoint instance) {
        this(fluent, instance, true);
    }

    public MountPointBuilder(MountPointFluent<?> fluent, MountPoint instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDestination(instance.getDestination());
        fluent.withDriver(instance.getDriver());
        fluent.withMode(instance.getMode());
        fluent.withName(instance.getName());
        fluent.withRW(instance.getRW());
        fluent.withSource(instance.getSource());
        this.validationEnabled = validationEnabled;
    }

    public MountPointBuilder(MountPoint instance) {
        this(instance, (Boolean)true);
    }

    public MountPointBuilder(MountPoint instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDestination(instance.getDestination());
        this.withDriver(instance.getDriver());
        this.withMode(instance.getMode());
        this.withName(instance.getName());
        this.withRW(instance.getRW());
        this.withSource(instance.getSource());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableMountPoint build() {
        EditableMountPoint buildable = new EditableMountPoint(this.fluent.getDestination(), this.fluent.getDriver(), this.fluent.getMode(), this.fluent.getName(), this.fluent.isRW(), this.fluent.getSource());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MountPointBuilder that = (MountPointBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

