/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.model.MemoryStats;
import io.fabric8.docker.api.model.MemoryStatsFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class MemoryStatsFluentImpl<A extends MemoryStatsFluent<A>>
extends BaseFluent<A>
implements MemoryStatsFluent<A> {
    private Long failcnt;
    private Long limit;
    private Long maxUsage;
    private Map<String, Long> stats = new LinkedHashMap<String, Long>();
    private Long usage;

    public MemoryStatsFluentImpl() {
    }

    public MemoryStatsFluentImpl(MemoryStats instance) {
        this.withFailcnt(instance.getFailcnt());
        this.withLimit(instance.getLimit());
        this.withMaxUsage(instance.getMaxUsage());
        this.withStats(instance.getStats());
        this.withUsage(instance.getUsage());
    }

    @Override
    public Long getFailcnt() {
        return this.failcnt;
    }

    @Override
    public A withFailcnt(Long failcnt) {
        this.failcnt = failcnt;
        return (A)this;
    }

    @Override
    public Boolean hasFailcnt() {
        return this.failcnt != null;
    }

    @Override
    public Long getLimit() {
        return this.limit;
    }

    @Override
    public A withLimit(Long limit) {
        this.limit = limit;
        return (A)this;
    }

    @Override
    public Boolean hasLimit() {
        return this.limit != null;
    }

    @Override
    public Long getMaxUsage() {
        return this.maxUsage;
    }

    @Override
    public A withMaxUsage(Long maxUsage) {
        this.maxUsage = maxUsage;
        return (A)this;
    }

    @Override
    public Boolean hasMaxUsage() {
        return this.maxUsage != null;
    }

    @Override
    public A addToStats(String key, Long value) {
        if (key != null && value != null) {
            this.stats.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToStats(Map<String, Long> map) {
        if (map != null) {
            this.stats.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromStats(String key) {
        if (key != null) {
            this.stats.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromStats(Map<String, Long> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.stats.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Long> getStats() {
        return this.stats;
    }

    @Override
    public A withStats(Map<String, Long> stats) {
        this.stats.clear();
        if (stats != null) {
            this.stats.putAll(stats);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStats() {
        return this.stats != null;
    }

    @Override
    public Long getUsage() {
        return this.usage;
    }

    @Override
    public A withUsage(Long usage) {
        this.usage = usage;
        return (A)this;
    }

    @Override
    public Boolean hasUsage() {
        return this.usage != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemoryStatsFluentImpl that = (MemoryStatsFluentImpl)o;
        if (this.failcnt != null ? !this.failcnt.equals(that.failcnt) : that.failcnt != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.maxUsage != null ? !this.maxUsage.equals(that.maxUsage) : that.maxUsage != null) {
            return false;
        }
        if (this.stats != null ? !this.stats.equals(that.stats) : that.stats != null) {
            return false;
        }
        return !(this.usage != null ? !this.usage.equals(that.usage) : that.usage != null);
    }
}

