/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.IndexInfo;
import io.fabric8.docker.api.model.IndexInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IndexInfoFluentImpl<A extends IndexInfoFluent<A>>
extends BaseFluent<A>
implements IndexInfoFluent<A> {
    private List<String> Mirrors = new ArrayList<String>();
    private String Name;
    private Boolean Official;
    private Boolean Secure;

    public IndexInfoFluentImpl() {
    }

    public IndexInfoFluentImpl(IndexInfo instance) {
        this.withMirrors(instance.getMirrors());
        this.withName(instance.getName());
        this.withOfficial(instance.getOfficial());
        this.withSecure(instance.getSecure());
    }

    @Override
    public A addToMirrors(int index, String item) {
        this.Mirrors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMirrors(int index, String item) {
        this.Mirrors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMirrors(String ... items) {
        for (String item : items) {
            this.Mirrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMirrors(Collection<String> items) {
        for (String item : items) {
            this.Mirrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMirrors(String ... items) {
        for (String item : items) {
            this.Mirrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMirrors(Collection<String> items) {
        for (String item : items) {
            this.Mirrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMirrors() {
        return this.Mirrors;
    }

    @Override
    public String getMirror(int index) {
        return this.Mirrors.get(index);
    }

    @Override
    public String getFirstMirror() {
        return this.Mirrors.get(0);
    }

    @Override
    public String getLastMirror() {
        return this.Mirrors.get(this.Mirrors.size() - 1);
    }

    @Override
    public String getMatchingMirror(Predicate<String> predicate) {
        for (String item : this.Mirrors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withMirrors(List<String> Mirrors) {
        this.Mirrors.clear();
        if (Mirrors != null) {
            for (String item : Mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withMirrors(String ... Mirrors) {
        this.Mirrors.clear();
        if (Mirrors != null) {
            for (String item : Mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMirrors() {
        return this.Mirrors != null && !this.Mirrors.isEmpty();
    }

    @Override
    public String getName() {
        return this.Name;
    }

    @Override
    public A withName(String Name) {
        this.Name = Name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.Name != null;
    }

    @Override
    public Boolean isOfficial() {
        return this.Official;
    }

    @Override
    public A withOfficial(Boolean Official) {
        this.Official = Official;
        return (A)this;
    }

    @Override
    public Boolean hasOfficial() {
        return this.Official != null;
    }

    @Override
    public Boolean isSecure() {
        return this.Secure;
    }

    @Override
    public A withSecure(Boolean Secure) {
        this.Secure = Secure;
        return (A)this;
    }

    @Override
    public Boolean hasSecure() {
        return this.Secure != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexInfoFluentImpl that = (IndexInfoFluentImpl)o;
        if (this.Mirrors != null ? !this.Mirrors.equals(that.Mirrors) : that.Mirrors != null) {
            return false;
        }
        if (this.Name != null ? !this.Name.equals(that.Name) : that.Name != null) {
            return false;
        }
        if (this.Official != null ? !this.Official.equals(that.Official) : that.Official != null) {
            return false;
        }
        return !(this.Secure != null ? !this.Secure.equals(that.Secure) : that.Secure != null);
    }
}

