/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableImageInspect;
import io.fabric8.docker.api.model.ImageInspect;
import io.fabric8.docker.api.model.ImageInspectFluent;
import io.fabric8.docker.api.model.ImageInspectFluentImpl;

public class ImageInspectBuilder
extends ImageInspectFluentImpl<ImageInspectBuilder>
implements VisitableBuilder<ImageInspect, ImageInspectBuilder> {
    ImageInspectFluent<?> fluent;
    Boolean validationEnabled;

    public ImageInspectBuilder() {
        this(true);
    }

    public ImageInspectBuilder(Boolean validationEnabled) {
        this(new ImageInspect(), validationEnabled);
    }

    public ImageInspectBuilder(ImageInspectFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageInspectBuilder(ImageInspectFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageInspect(), validationEnabled);
    }

    public ImageInspectBuilder(ImageInspectFluent<?> fluent, ImageInspect instance) {
        this(fluent, instance, true);
    }

    public ImageInspectBuilder(ImageInspectFluent<?> fluent, ImageInspect instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withArchitecture(instance.getArchitecture());
        fluent.withAuthor(instance.getAuthor());
        fluent.withComment(instance.getComment());
        fluent.withConfig(instance.getConfig());
        fluent.withContainer(instance.getContainer());
        fluent.withContainerConfig(instance.getContainerConfig());
        fluent.withCreated(instance.getCreated());
        fluent.withDockerVersion(instance.getDockerVersion());
        fluent.withGraphDriver(instance.getGraphDriver());
        fluent.withId(instance.getId());
        fluent.withOs(instance.getOs());
        fluent.withParent(instance.getParent());
        fluent.withRepoDigests(instance.getRepoDigests());
        fluent.withRepoTags(instance.getRepoTags());
        fluent.withSize(instance.getSize());
        fluent.withVirtualSize(instance.getVirtualSize());
        this.validationEnabled = validationEnabled;
    }

    public ImageInspectBuilder(ImageInspect instance) {
        this(instance, (Boolean)true);
    }

    public ImageInspectBuilder(ImageInspect instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withArchitecture(instance.getArchitecture());
        this.withAuthor(instance.getAuthor());
        this.withComment(instance.getComment());
        this.withConfig(instance.getConfig());
        this.withContainer(instance.getContainer());
        this.withContainerConfig(instance.getContainerConfig());
        this.withCreated(instance.getCreated());
        this.withDockerVersion(instance.getDockerVersion());
        this.withGraphDriver(instance.getGraphDriver());
        this.withId(instance.getId());
        this.withOs(instance.getOs());
        this.withParent(instance.getParent());
        this.withRepoDigests(instance.getRepoDigests());
        this.withRepoTags(instance.getRepoTags());
        this.withSize(instance.getSize());
        this.withVirtualSize(instance.getVirtualSize());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableImageInspect build() {
        EditableImageInspect buildable = new EditableImageInspect(this.fluent.getArchitecture(), this.fluent.getAuthor(), this.fluent.getComment(), this.fluent.getConfig(), this.fluent.getContainer(), this.fluent.getContainerConfig(), this.fluent.getCreated(), this.fluent.getDockerVersion(), this.fluent.getGraphDriver(), this.fluent.getId(), this.fluent.getOs(), this.fluent.getParent(), this.fluent.getRepoDigests(), this.fluent.getRepoTags(), this.fluent.getSize(), this.fluent.getVirtualSize());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageInspectBuilder that = (ImageInspectBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

