/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.ImageHistory;
import io.fabric8.docker.api.model.ImageHistoryFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageHistoryFluentImpl<A extends ImageHistoryFluent<A>>
extends BaseFluent<A>
implements ImageHistoryFluent<A> {
    private String Comment;
    private Long Created;
    private String CreatedBy;
    private String Id;
    private Long Size;
    private List<String> Tags = new ArrayList<String>();

    public ImageHistoryFluentImpl() {
    }

    public ImageHistoryFluentImpl(ImageHistory instance) {
        this.withComment(instance.getComment());
        this.withCreated(instance.getCreated());
        this.withCreatedBy(instance.getCreatedBy());
        this.withId(instance.getId());
        this.withSize(instance.getSize());
        this.withTags(instance.getTags());
    }

    @Override
    public String getComment() {
        return this.Comment;
    }

    @Override
    public A withComment(String Comment) {
        this.Comment = Comment;
        return (A)this;
    }

    @Override
    public Boolean hasComment() {
        return this.Comment != null;
    }

    @Override
    public Long getCreated() {
        return this.Created;
    }

    @Override
    public A withCreated(Long Created) {
        this.Created = Created;
        return (A)this;
    }

    @Override
    public Boolean hasCreated() {
        return this.Created != null;
    }

    @Override
    public String getCreatedBy() {
        return this.CreatedBy;
    }

    @Override
    public A withCreatedBy(String CreatedBy) {
        this.CreatedBy = CreatedBy;
        return (A)this;
    }

    @Override
    public Boolean hasCreatedBy() {
        return this.CreatedBy != null;
    }

    @Override
    public String getId() {
        return this.Id;
    }

    @Override
    public A withId(String Id) {
        this.Id = Id;
        return (A)this;
    }

    @Override
    public Boolean hasId() {
        return this.Id != null;
    }

    @Override
    public Long getSize() {
        return this.Size;
    }

    @Override
    public A withSize(Long Size) {
        this.Size = Size;
        return (A)this;
    }

    @Override
    public Boolean hasSize() {
        return this.Size != null;
    }

    @Override
    public A addToTags(int index, String item) {
        this.Tags.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTags(int index, String item) {
        this.Tags.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTags(String ... items) {
        for (String item : items) {
            this.Tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTags(Collection<String> items) {
        for (String item : items) {
            this.Tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(String ... items) {
        for (String item : items) {
            this.Tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTags(Collection<String> items) {
        for (String item : items) {
            this.Tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTags() {
        return this.Tags;
    }

    @Override
    public String getTag(int index) {
        return this.Tags.get(index);
    }

    @Override
    public String getFirstTag() {
        return this.Tags.get(0);
    }

    @Override
    public String getLastTag() {
        return this.Tags.get(this.Tags.size() - 1);
    }

    @Override
    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.Tags) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withTags(List<String> Tags) {
        this.Tags.clear();
        if (Tags != null) {
            for (String item : Tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTags(String ... Tags) {
        this.Tags.clear();
        if (Tags != null) {
            for (String item : Tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.Tags != null && !this.Tags.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageHistoryFluentImpl that = (ImageHistoryFluentImpl)o;
        if (this.Comment != null ? !this.Comment.equals(that.Comment) : that.Comment != null) {
            return false;
        }
        if (this.Created != null ? !this.Created.equals(that.Created) : that.Created != null) {
            return false;
        }
        if (this.CreatedBy != null ? !this.CreatedBy.equals(that.CreatedBy) : that.CreatedBy != null) {
            return false;
        }
        if (this.Id != null ? !this.Id.equals(that.Id) : that.Id != null) {
            return false;
        }
        if (this.Size != null ? !this.Size.equals(that.Size) : that.Size != null) {
            return false;
        }
        return !(this.Tags != null ? !this.Tags.equals(that.Tags) : that.Tags != null);
    }
}

