/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.Image;
import io.fabric8.docker.api.model.ImageFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ImageFluentImpl<A extends ImageFluent<A>>
extends BaseFluent<A>
implements ImageFluent<A> {
    private Long Created;
    private String Id;
    private Map<String, String> Labels = new LinkedHashMap<String, String>();
    private String ParentId;
    private List<String> RepoDigests = new ArrayList<String>();
    private List<String> RepoTags = new ArrayList<String>();
    private Long Size;
    private Long VirtualSize;

    public ImageFluentImpl() {
    }

    public ImageFluentImpl(Image instance) {
        this.withCreated(instance.getCreated());
        this.withId(instance.getId());
        this.withLabels(instance.getLabels());
        this.withParentId(instance.getParentId());
        this.withRepoDigests(instance.getRepoDigests());
        this.withRepoTags(instance.getRepoTags());
        this.withSize(instance.getSize());
        this.withVirtualSize(instance.getVirtualSize());
    }

    @Override
    public Long getCreated() {
        return this.Created;
    }

    @Override
    public A withCreated(Long Created) {
        this.Created = Created;
        return (A)this;
    }

    @Override
    public Boolean hasCreated() {
        return this.Created != null;
    }

    @Override
    public String getId() {
        return this.Id;
    }

    @Override
    public A withId(String Id) {
        this.Id = Id;
        return (A)this;
    }

    @Override
    public Boolean hasId() {
        return this.Id != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (key != null && value != null) {
            this.Labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (map != null) {
            this.Labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (key != null) {
            this.Labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.Labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.Labels;
    }

    @Override
    public A withLabels(Map<String, String> Labels) {
        this.Labels.clear();
        if (Labels != null) {
            this.Labels.putAll(Labels);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.Labels != null;
    }

    @Override
    public String getParentId() {
        return this.ParentId;
    }

    @Override
    public A withParentId(String ParentId) {
        this.ParentId = ParentId;
        return (A)this;
    }

    @Override
    public Boolean hasParentId() {
        return this.ParentId != null;
    }

    @Override
    public A addToRepoDigests(int index, String item) {
        this.RepoDigests.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRepoDigests(int index, String item) {
        this.RepoDigests.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRepoDigests(String ... items) {
        for (String item : items) {
            this.RepoDigests.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRepoDigests(Collection<String> items) {
        for (String item : items) {
            this.RepoDigests.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRepoDigests(String ... items) {
        for (String item : items) {
            this.RepoDigests.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRepoDigests(Collection<String> items) {
        for (String item : items) {
            this.RepoDigests.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRepoDigests() {
        return this.RepoDigests;
    }

    @Override
    public String getRepoDigest(int index) {
        return this.RepoDigests.get(index);
    }

    @Override
    public String getFirstRepoDigest() {
        return this.RepoDigests.get(0);
    }

    @Override
    public String getLastRepoDigest() {
        return this.RepoDigests.get(this.RepoDigests.size() - 1);
    }

    @Override
    public String getMatchingRepoDigest(Predicate<String> predicate) {
        for (String item : this.RepoDigests) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withRepoDigests(List<String> RepoDigests) {
        this.RepoDigests.clear();
        if (RepoDigests != null) {
            for (String item : RepoDigests) {
                this.addToRepoDigests(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRepoDigests(String ... RepoDigests) {
        this.RepoDigests.clear();
        if (RepoDigests != null) {
            for (String item : RepoDigests) {
                this.addToRepoDigests(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepoDigests() {
        return this.RepoDigests != null && !this.RepoDigests.isEmpty();
    }

    @Override
    public A addToRepoTags(int index, String item) {
        this.RepoTags.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRepoTags(int index, String item) {
        this.RepoTags.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRepoTags(String ... items) {
        for (String item : items) {
            this.RepoTags.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRepoTags(Collection<String> items) {
        for (String item : items) {
            this.RepoTags.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRepoTags(String ... items) {
        for (String item : items) {
            this.RepoTags.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRepoTags(Collection<String> items) {
        for (String item : items) {
            this.RepoTags.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRepoTags() {
        return this.RepoTags;
    }

    @Override
    public String getRepoTag(int index) {
        return this.RepoTags.get(index);
    }

    @Override
    public String getFirstRepoTag() {
        return this.RepoTags.get(0);
    }

    @Override
    public String getLastRepoTag() {
        return this.RepoTags.get(this.RepoTags.size() - 1);
    }

    @Override
    public String getMatchingRepoTag(Predicate<String> predicate) {
        for (String item : this.RepoTags) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withRepoTags(List<String> RepoTags) {
        this.RepoTags.clear();
        if (RepoTags != null) {
            for (String item : RepoTags) {
                this.addToRepoTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRepoTags(String ... RepoTags) {
        this.RepoTags.clear();
        if (RepoTags != null) {
            for (String item : RepoTags) {
                this.addToRepoTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepoTags() {
        return this.RepoTags != null && !this.RepoTags.isEmpty();
    }

    @Override
    public Long getSize() {
        return this.Size;
    }

    @Override
    public A withSize(Long Size) {
        this.Size = Size;
        return (A)this;
    }

    @Override
    public Boolean hasSize() {
        return this.Size != null;
    }

    @Override
    public Long getVirtualSize() {
        return this.VirtualSize;
    }

    @Override
    public A withVirtualSize(Long VirtualSize) {
        this.VirtualSize = VirtualSize;
        return (A)this;
    }

    @Override
    public Boolean hasVirtualSize() {
        return this.VirtualSize != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageFluentImpl that = (ImageFluentImpl)o;
        if (this.Created != null ? !this.Created.equals(that.Created) : that.Created != null) {
            return false;
        }
        if (this.Id != null ? !this.Id.equals(that.Id) : that.Id != null) {
            return false;
        }
        if (this.Labels != null ? !this.Labels.equals(that.Labels) : that.Labels != null) {
            return false;
        }
        if (this.ParentId != null ? !this.ParentId.equals(that.ParentId) : that.ParentId != null) {
            return false;
        }
        if (this.RepoDigests != null ? !this.RepoDigests.equals(that.RepoDigests) : that.RepoDigests != null) {
            return false;
        }
        if (this.RepoTags != null ? !this.RepoTags.equals(that.RepoTags) : that.RepoTags != null) {
            return false;
        }
        if (this.Size != null ? !this.Size.equals(that.Size) : that.Size != null) {
            return false;
        }
        return !(this.VirtualSize != null ? !this.VirtualSize.equals(that.VirtualSize) : that.VirtualSize != null);
    }
}

