/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableImage;
import io.fabric8.docker.api.model.Image;
import io.fabric8.docker.api.model.ImageFluent;
import io.fabric8.docker.api.model.ImageFluentImpl;

public class ImageBuilder
extends ImageFluentImpl<ImageBuilder>
implements VisitableBuilder<Image, ImageBuilder> {
    ImageFluent<?> fluent;
    Boolean validationEnabled;

    public ImageBuilder() {
        this(true);
    }

    public ImageBuilder(Boolean validationEnabled) {
        this(new Image(), validationEnabled);
    }

    public ImageBuilder(ImageFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageBuilder(ImageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Image(), validationEnabled);
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance) {
        this(fluent, instance, true);
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCreated(instance.getCreated());
        fluent.withId(instance.getId());
        fluent.withLabels(instance.getLabels());
        fluent.withParentId(instance.getParentId());
        fluent.withRepoDigests(instance.getRepoDigests());
        fluent.withRepoTags(instance.getRepoTags());
        fluent.withSize(instance.getSize());
        fluent.withVirtualSize(instance.getVirtualSize());
        this.validationEnabled = validationEnabled;
    }

    public ImageBuilder(Image instance) {
        this(instance, (Boolean)true);
    }

    public ImageBuilder(Image instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCreated(instance.getCreated());
        this.withId(instance.getId());
        this.withLabels(instance.getLabels());
        this.withParentId(instance.getParentId());
        this.withRepoDigests(instance.getRepoDigests());
        this.withRepoTags(instance.getRepoTags());
        this.withSize(instance.getSize());
        this.withVirtualSize(instance.getVirtualSize());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableImage build() {
        EditableImage buildable = new EditableImage(this.fluent.getCreated(), this.fluent.getId(), this.fluent.getLabels(), this.fluent.getParentId(), this.fluent.getRepoDigests(), this.fluent.getRepoTags(), this.fluent.getSize(), this.fluent.getVirtualSize());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageBuilder that = (ImageBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

