/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.IPAM;
import io.fabric8.docker.api.model.IPAMConfig;
import io.fabric8.docker.api.model.IPAMConfigBuilder;
import io.fabric8.docker.api.model.IPAMConfigFluentImpl;
import io.fabric8.docker.api.model.IPAMFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IPAMFluentImpl<A extends IPAMFluent<A>>
extends BaseFluent<A>
implements IPAMFluent<A> {
    private List<IPAMConfigBuilder> Config = new ArrayList<IPAMConfigBuilder>();
    private String Driver;

    public IPAMFluentImpl() {
    }

    public IPAMFluentImpl(IPAM instance) {
        this.withConfig(instance.getConfig());
        this.withDriver(instance.getDriver());
    }

    @Override
    public A addToConfig(int index, IPAMConfig item) {
        IPAMConfigBuilder builder = new IPAMConfigBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.Config.add(index >= 0 ? index : this.Config.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConfig(int index, IPAMConfig item) {
        IPAMConfigBuilder builder = new IPAMConfigBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.Config.size()) {
            this.Config.add(builder);
        } else {
            this.Config.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(IPAMConfig ... items) {
        for (IPAMConfig item : items) {
            IPAMConfigBuilder builder = new IPAMConfigBuilder(item);
            this._visitables.add(builder);
            this.Config.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfig(Collection<IPAMConfig> items) {
        for (IPAMConfig item : items) {
            IPAMConfigBuilder builder = new IPAMConfigBuilder(item);
            this._visitables.add(builder);
            this.Config.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(IPAMConfig ... items) {
        for (IPAMConfig item : items) {
            IPAMConfigBuilder builder = new IPAMConfigBuilder(item);
            this._visitables.remove(builder);
            this.Config.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfig(Collection<IPAMConfig> items) {
        for (IPAMConfig item : items) {
            IPAMConfigBuilder builder = new IPAMConfigBuilder(item);
            this._visitables.remove(builder);
            this.Config.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IPAMConfig> getConfig() {
        return IPAMFluentImpl.build(this.Config);
    }

    @Override
    public List<IPAMConfig> buildConfig() {
        return IPAMFluentImpl.build(this.Config);
    }

    @Override
    public IPAMConfig buildConfig(int index) {
        return this.Config.get(index).build();
    }

    @Override
    public IPAMConfig buildFirstConfig() {
        return this.Config.get(0).build();
    }

    @Override
    public IPAMConfig buildLastConfig() {
        return this.Config.get(this.Config.size() - 1).build();
    }

    @Override
    public IPAMConfig buildMatchingConfig(Predicate<IPAMConfigBuilder> predicate) {
        for (IPAMConfigBuilder item : this.Config) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConfig(List<IPAMConfig> Config2) {
        this._visitables.removeAll(this.Config);
        this.Config.clear();
        if (Config2 != null) {
            for (IPAMConfig item : Config2) {
                this.addToConfig(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConfig(IPAMConfig ... Config2) {
        this.Config.clear();
        if (Config2 != null) {
            for (IPAMConfig item : Config2) {
                this.addToConfig(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.Config != null && !this.Config.isEmpty();
    }

    @Override
    public IPAMFluent.ConfigNested<A> addNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public IPAMFluent.ConfigNested<A> addNewConfigLike(IPAMConfig item) {
        return new ConfigNestedImpl(-1, item);
    }

    @Override
    public IPAMFluent.ConfigNested<A> setNewConfigLike(int index, IPAMConfig item) {
        return new ConfigNestedImpl(index, item);
    }

    @Override
    public IPAMFluent.ConfigNested<A> editConfig(int index) {
        if (this.Config.size() <= index) {
            throw new RuntimeException("Can't edit Config. Index exceeds size.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    @Override
    public IPAMFluent.ConfigNested<A> editFirstConfig() {
        if (this.Config.size() == 0) {
            throw new RuntimeException("Can't edit first Config. The list is empty.");
        }
        return this.setNewConfigLike(0, this.buildConfig(0));
    }

    @Override
    public IPAMFluent.ConfigNested<A> editLastConfig() {
        int index = this.Config.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last Config. The list is empty.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    @Override
    public IPAMFluent.ConfigNested<A> editMatchingConfig(Predicate<IPAMConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.Config.size(); ++i) {
            if (!predicate.apply(this.Config.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching Config. No match found.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    @Override
    public String getDriver() {
        return this.Driver;
    }

    @Override
    public A withDriver(String Driver) {
        this.Driver = Driver;
        return (A)this;
    }

    @Override
    public Boolean hasDriver() {
        return this.Driver != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPAMFluentImpl that = (IPAMFluentImpl)o;
        if (this.Config != null ? !this.Config.equals(that.Config) : that.Config != null) {
            return false;
        }
        return !(this.Driver != null ? !this.Driver.equals(that.Driver) : that.Driver != null);
    }

    public class ConfigNestedImpl<N>
    extends IPAMConfigFluentImpl<IPAMFluent.ConfigNested<N>>
    implements IPAMFluent.ConfigNested<N>,
    Nested<N> {
        private final IPAMConfigBuilder builder;
        private final int index;

        ConfigNestedImpl(int index, IPAMConfig item) {
            this.index = index;
            this.builder = new IPAMConfigBuilder(this, item);
        }

        ConfigNestedImpl() {
            this.index = -1;
            this.builder = new IPAMConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)IPAMFluentImpl.this.setToConfig(this.index, this.builder.build());
        }

        @Override
        public N endConfig() {
            return this.and();
        }
    }
}

