/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerState;
import io.fabric8.docker.api.model.ContainerStateFluent;
import io.fabric8.docker.api.model.ContainerStateFluentImpl;
import io.fabric8.docker.api.model.EditableContainerState;

public class ContainerStateBuilder
extends ContainerStateFluentImpl<ContainerStateBuilder>
implements VisitableBuilder<ContainerState, ContainerStateBuilder> {
    ContainerStateFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStateBuilder() {
        this(true);
    }

    public ContainerStateBuilder(Boolean validationEnabled) {
        this(new ContainerState(), validationEnabled);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerState(), validationEnabled);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance) {
        this(fluent, instance, true);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDead(instance.getDead());
        fluent.withError(instance.getError());
        fluent.withExitCode(instance.getExitCode());
        fluent.withFinishedAt(instance.getFinishedAt());
        fluent.withOOMKilled(instance.getOOMKilled());
        fluent.withPaused(instance.getPaused());
        fluent.withPid(instance.getPid());
        fluent.withRestarting(instance.getRestarting());
        fluent.withRunning(instance.getRunning());
        fluent.withStartedAt(instance.getStartedAt());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStateBuilder(ContainerState instance) {
        this(instance, (Boolean)true);
    }

    public ContainerStateBuilder(ContainerState instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDead(instance.getDead());
        this.withError(instance.getError());
        this.withExitCode(instance.getExitCode());
        this.withFinishedAt(instance.getFinishedAt());
        this.withOOMKilled(instance.getOOMKilled());
        this.withPaused(instance.getPaused());
        this.withPid(instance.getPid());
        this.withRestarting(instance.getRestarting());
        this.withRunning(instance.getRunning());
        this.withStartedAt(instance.getStartedAt());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableContainerState build() {
        EditableContainerState buildable = new EditableContainerState(this.fluent.isDead(), this.fluent.getError(), this.fluent.getExitCode(), this.fluent.getFinishedAt(), this.fluent.isOOMKilled(), this.fluent.isPaused(), this.fluent.getPid(), this.fluent.isRestarting(), this.fluent.isRunning(), this.fluent.getStartedAt(), this.fluent.getStatus());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateBuilder that = (ContainerStateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

