/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerProcessList;
import io.fabric8.docker.api.model.ContainerProcessListFluent;
import io.fabric8.docker.api.model.ContainerProcessListFluentImpl;
import io.fabric8.docker.api.model.EditableContainerProcessList;

public class ContainerProcessListBuilder
extends ContainerProcessListFluentImpl<ContainerProcessListBuilder>
implements VisitableBuilder<ContainerProcessList, ContainerProcessListBuilder> {
    ContainerProcessListFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerProcessListBuilder() {
        this(true);
    }

    public ContainerProcessListBuilder(Boolean validationEnabled) {
        this(new ContainerProcessList(), validationEnabled);
    }

    public ContainerProcessListBuilder(ContainerProcessListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerProcessListBuilder(ContainerProcessListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerProcessList(), validationEnabled);
    }

    public ContainerProcessListBuilder(ContainerProcessListFluent<?> fluent, ContainerProcessList instance) {
        this(fluent, instance, true);
    }

    public ContainerProcessListBuilder(ContainerProcessListFluent<?> fluent, ContainerProcessList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProcesses(instance.getProcesses());
        fluent.withTitles(instance.getTitles());
        this.validationEnabled = validationEnabled;
    }

    public ContainerProcessListBuilder(ContainerProcessList instance) {
        this(instance, (Boolean)true);
    }

    public ContainerProcessListBuilder(ContainerProcessList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProcesses(instance.getProcesses());
        this.withTitles(instance.getTitles());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableContainerProcessList build() {
        EditableContainerProcessList buildable = new EditableContainerProcessList(this.fluent.getProcesses(), this.fluent.getTitles());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerProcessListBuilder that = (ContainerProcessListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

