/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.Config;
import io.fabric8.docker.api.model.ConfigBuilder;
import io.fabric8.docker.api.model.ConfigFluentImpl;
import io.fabric8.docker.api.model.ContainerInspect;
import io.fabric8.docker.api.model.ContainerInspectFluent;
import io.fabric8.docker.api.model.ContainerJSONBaseFluentImpl;
import io.fabric8.docker.api.model.MountPoint;
import io.fabric8.docker.api.model.MountPointBuilder;
import io.fabric8.docker.api.model.MountPointFluentImpl;
import io.fabric8.docker.api.model.NetworkSettings;
import io.fabric8.docker.api.model.NetworkSettingsBuilder;
import io.fabric8.docker.api.model.NetworkSettingsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerInspectFluentImpl<A extends ContainerInspectFluent<A>>
extends ContainerJSONBaseFluentImpl<A>
implements ContainerInspectFluent<A> {
    private ConfigBuilder Config;
    private List<MountPointBuilder> Mounts = new ArrayList<MountPointBuilder>();
    private NetworkSettingsBuilder NetworkSettings;

    public ContainerInspectFluentImpl() {
    }

    public ContainerInspectFluentImpl(ContainerInspect instance) {
        this.withAppArmorProfile(instance.getAppArmorProfile());
        this.withArgs(instance.getArgs());
        this.withCreated(instance.getCreated());
        this.withDriver(instance.getDriver());
        this.withExecDriver(instance.getExecDriver());
        this.withExecIDs(instance.getExecIDs());
        this.withGraphDriver(instance.getGraphDriver());
        this.withHostConfig(instance.getHostConfig());
        this.withHostnamePath(instance.getHostnamePath());
        this.withHostsPath(instance.getHostsPath());
        this.withId(instance.getId());
        this.withImage(instance.getImage());
        this.withLogPath(instance.getLogPath());
        this.withMountLabel(instance.getMountLabel());
        this.withName(instance.getName());
        this.withPath(instance.getPath());
        this.withProcessLabel(instance.getProcessLabel());
        this.withResolvConfPath(instance.getResolvConfPath());
        this.withRestartCount(instance.getRestartCount());
        this.withSizeRootFs(instance.getSizeRootFs());
        this.withSizeRw(instance.getSizeRw());
        this.withState(instance.getState());
        this.withConfig(instance.getConfig());
        this.withMounts(instance.getMounts());
        this.withNetworkSettings(instance.getNetworkSettings());
        this.withConfig(instance.getConfig());
        this.withMounts(instance.getMounts());
        this.withNetworkSettings(instance.getNetworkSettings());
    }

    @Override
    @Deprecated
    public Config getConfig() {
        return this.Config != null ? this.Config.build() : null;
    }

    @Override
    public Config buildConfig() {
        return this.Config != null ? this.Config.build() : null;
    }

    @Override
    public A withConfig(Config Config2) {
        this._visitables.remove(this.Config);
        if (Config2 != null) {
            this.Config = new ConfigBuilder(Config2);
            this._visitables.add(this.Config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.Config != null;
    }

    @Override
    public ContainerInspectFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public ContainerInspectFluent.ConfigNested<A> withNewConfigLike(Config item) {
        return new ConfigNestedImpl(item);
    }

    @Override
    public ContainerInspectFluent.ConfigNested<A> editConfig() {
        return this.withNewConfigLike(this.getConfig());
    }

    @Override
    public ContainerInspectFluent.ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : new ConfigBuilder().build());
    }

    @Override
    public ContainerInspectFluent.ConfigNested<A> editOrNewConfigLike(Config item) {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : item);
    }

    @Override
    public A addToMounts(int index, MountPoint item) {
        MountPointBuilder builder = new MountPointBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.Mounts.add(index >= 0 ? index : this.Mounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMounts(int index, MountPoint item) {
        MountPointBuilder builder = new MountPointBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.Mounts.size()) {
            this.Mounts.add(builder);
        } else {
            this.Mounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMounts(MountPoint ... items) {
        for (MountPoint item : items) {
            MountPointBuilder builder = new MountPointBuilder(item);
            this._visitables.add(builder);
            this.Mounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMounts(Collection<MountPoint> items) {
        for (MountPoint item : items) {
            MountPointBuilder builder = new MountPointBuilder(item);
            this._visitables.add(builder);
            this.Mounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMounts(MountPoint ... items) {
        for (MountPoint item : items) {
            MountPointBuilder builder = new MountPointBuilder(item);
            this._visitables.remove(builder);
            this.Mounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMounts(Collection<MountPoint> items) {
        for (MountPoint item : items) {
            MountPointBuilder builder = new MountPointBuilder(item);
            this._visitables.remove(builder);
            this.Mounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MountPoint> getMounts() {
        return ContainerInspectFluentImpl.build(this.Mounts);
    }

    @Override
    public List<MountPoint> buildMounts() {
        return ContainerInspectFluentImpl.build(this.Mounts);
    }

    @Override
    public MountPoint buildMount(int index) {
        return this.Mounts.get(index).build();
    }

    @Override
    public MountPoint buildFirstMount() {
        return this.Mounts.get(0).build();
    }

    @Override
    public MountPoint buildLastMount() {
        return this.Mounts.get(this.Mounts.size() - 1).build();
    }

    @Override
    public MountPoint buildMatchingMount(Predicate<MountPointBuilder> predicate) {
        for (MountPointBuilder item : this.Mounts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withMounts(List<MountPoint> Mounts) {
        this._visitables.removeAll(this.Mounts);
        this.Mounts.clear();
        if (Mounts != null) {
            for (MountPoint item : Mounts) {
                this.addToMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withMounts(MountPoint ... Mounts) {
        this.Mounts.clear();
        if (Mounts != null) {
            for (MountPoint item : Mounts) {
                this.addToMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMounts() {
        return this.Mounts != null && !this.Mounts.isEmpty();
    }

    @Override
    public ContainerInspectFluent.MountsNested<A> addNewMount() {
        return new MountsNestedImpl();
    }

    @Override
    public ContainerInspectFluent.MountsNested<A> addNewMountLike(MountPoint item) {
        return new MountsNestedImpl(-1, item);
    }

    @Override
    public ContainerInspectFluent.MountsNested<A> setNewMountLike(int index, MountPoint item) {
        return new MountsNestedImpl(index, item);
    }

    @Override
    public ContainerInspectFluent.MountsNested<A> editMount(int index) {
        if (this.Mounts.size() <= index) {
            throw new RuntimeException("Can't edit Mounts. Index exceeds size.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public ContainerInspectFluent.MountsNested<A> editFirstMount() {
        if (this.Mounts.size() == 0) {
            throw new RuntimeException("Can't edit first Mounts. The list is empty.");
        }
        return this.setNewMountLike(0, this.buildMount(0));
    }

    @Override
    public ContainerInspectFluent.MountsNested<A> editLastMount() {
        int index = this.Mounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last Mounts. The list is empty.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public ContainerInspectFluent.MountsNested<A> editMatchingMount(Predicate<MountPointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.Mounts.size(); ++i) {
            if (!predicate.apply(this.Mounts.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching Mounts. No match found.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    @Deprecated
    public NetworkSettings getNetworkSettings() {
        return this.NetworkSettings != null ? this.NetworkSettings.build() : null;
    }

    @Override
    public NetworkSettings buildNetworkSettings() {
        return this.NetworkSettings != null ? this.NetworkSettings.build() : null;
    }

    @Override
    public A withNetworkSettings(NetworkSettings NetworkSettings2) {
        this._visitables.remove(this.NetworkSettings);
        if (NetworkSettings2 != null) {
            this.NetworkSettings = new NetworkSettingsBuilder(NetworkSettings2);
            this._visitables.add(this.NetworkSettings);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNetworkSettings() {
        return this.NetworkSettings != null;
    }

    @Override
    public ContainerInspectFluent.NetworkSettingsNested<A> withNewNetworkSettings() {
        return new NetworkSettingsNestedImpl();
    }

    @Override
    public ContainerInspectFluent.NetworkSettingsNested<A> withNewNetworkSettingsLike(NetworkSettings item) {
        return new NetworkSettingsNestedImpl(item);
    }

    @Override
    public ContainerInspectFluent.NetworkSettingsNested<A> editNetworkSettings() {
        return this.withNewNetworkSettingsLike(this.getNetworkSettings());
    }

    @Override
    public ContainerInspectFluent.NetworkSettingsNested<A> editOrNewNetworkSettings() {
        return this.withNewNetworkSettingsLike(this.getNetworkSettings() != null ? this.getNetworkSettings() : new NetworkSettingsBuilder().build());
    }

    @Override
    public ContainerInspectFluent.NetworkSettingsNested<A> editOrNewNetworkSettingsLike(NetworkSettings item) {
        return this.withNewNetworkSettingsLike(this.getNetworkSettings() != null ? this.getNetworkSettings() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerInspectFluentImpl that = (ContainerInspectFluentImpl)o;
        if (this.Config != null ? !this.Config.equals(that.Config) : that.Config != null) {
            return false;
        }
        if (this.Mounts != null ? !this.Mounts.equals(that.Mounts) : that.Mounts != null) {
            return false;
        }
        return !(this.NetworkSettings != null ? !this.NetworkSettings.equals(that.NetworkSettings) : that.NetworkSettings != null);
    }

    public class NetworkSettingsNestedImpl<N>
    extends NetworkSettingsFluentImpl<ContainerInspectFluent.NetworkSettingsNested<N>>
    implements ContainerInspectFluent.NetworkSettingsNested<N>,
    Nested<N> {
        private final NetworkSettingsBuilder builder;

        NetworkSettingsNestedImpl(NetworkSettings item) {
            this.builder = new NetworkSettingsBuilder(this, item);
        }

        NetworkSettingsNestedImpl() {
            this.builder = new NetworkSettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerInspectFluentImpl.this.withNetworkSettings(this.builder.build());
        }

        @Override
        public N endNetworkSettings() {
            return this.and();
        }
    }

    public class MountsNestedImpl<N>
    extends MountPointFluentImpl<ContainerInspectFluent.MountsNested<N>>
    implements ContainerInspectFluent.MountsNested<N>,
    Nested<N> {
        private final MountPointBuilder builder;
        private final int index;

        MountsNestedImpl(int index, MountPoint item) {
            this.index = index;
            this.builder = new MountPointBuilder(this, item);
        }

        MountsNestedImpl() {
            this.index = -1;
            this.builder = new MountPointBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerInspectFluentImpl.this.setToMounts(this.index, this.builder.build());
        }

        @Override
        public N endMount() {
            return this.and();
        }
    }

    public class ConfigNestedImpl<N>
    extends ConfigFluentImpl<ContainerInspectFluent.ConfigNested<N>>
    implements ContainerInspectFluent.ConfigNested<N>,
    Nested<N> {
        private final ConfigBuilder builder;

        ConfigNestedImpl(Config item) {
            this.builder = new ConfigBuilder(this, item);
        }

        ConfigNestedImpl() {
            this.builder = new ConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerInspectFluentImpl.this.withConfig(this.builder.build());
        }

        @Override
        public N endConfig() {
            return this.and();
        }
    }
}

