/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerHostConfig;
import io.fabric8.docker.api.model.ContainerHostConfigFluent;
import io.fabric8.docker.api.model.ContainerHostConfigFluentImpl;
import io.fabric8.docker.api.model.EditableContainerHostConfig;

public class ContainerHostConfigBuilder
extends ContainerHostConfigFluentImpl<ContainerHostConfigBuilder>
implements VisitableBuilder<ContainerHostConfig, ContainerHostConfigBuilder> {
    ContainerHostConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerHostConfigBuilder() {
        this(true);
    }

    public ContainerHostConfigBuilder(Boolean validationEnabled) {
        this(new ContainerHostConfig(), validationEnabled);
    }

    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerHostConfig(), validationEnabled);
    }

    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent, ContainerHostConfig instance) {
        this(fluent, instance, true);
    }

    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent, ContainerHostConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNetworkMode(instance.getNetworkMode());
        this.validationEnabled = validationEnabled;
    }

    public ContainerHostConfigBuilder(ContainerHostConfig instance) {
        this(instance, (Boolean)true);
    }

    public ContainerHostConfigBuilder(ContainerHostConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNetworkMode(instance.getNetworkMode());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableContainerHostConfig build() {
        EditableContainerHostConfig buildable = new EditableContainerHostConfig(this.fluent.getNetworkMode());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerHostConfigBuilder that = (ContainerHostConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

