/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.ContainerCreateRequest;
import io.fabric8.docker.api.model.ContainerCreateRequestFluent;
import io.fabric8.docker.api.model.HostConfig;
import io.fabric8.docker.api.model.HostConfigBuilder;
import io.fabric8.docker.api.model.HostConfigFluentImpl;
import io.fabric8.docker.api.model.Protocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ContainerCreateRequestFluentImpl<A extends ContainerCreateRequestFluent<A>>
extends BaseFluent<A>
implements ContainerCreateRequestFluent<A> {
    private String name;
    private String hostname;
    private String domainname;
    private String user;
    private String memory;
    private String memorySwap;
    private String memoryReservation;
    private String kernelMemory;
    private String cpuShares;
    private String cpuPeriod;
    private String cpuQuota;
    private String cpuset;
    private String cpusetCpus;
    private String cpusetMems;
    private Integer blkioWeight;
    private Integer memorySwappiness;
    private Boolean oomKillDisable;
    private Boolean attachStdin;
    private Boolean attachStdout;
    private Boolean attachStderr;
    private Boolean tty;
    private Boolean openStdin;
    private Boolean stdinOnce;
    private Map<String, String> env = new LinkedHashMap<String, String>();
    private List<String> cmd = new ArrayList<String>();
    private String entrypoint;
    private String image;
    private Map<String, String> labels = new LinkedHashMap<String, String>();
    private Map<String, Object> volumes = new LinkedHashMap<String, Object>();
    private String workingDir;
    private Boolean networkDisabled;
    private String macAddress;
    private Map<Integer, Protocol> exposedPorts = new LinkedHashMap<Integer, Protocol>();
    private String stopSignal;
    private HostConfigBuilder hostConfig;

    public ContainerCreateRequestFluentImpl() {
    }

    public ContainerCreateRequestFluentImpl(ContainerCreateRequest instance) {
        this.withName(instance.getName());
        this.withCpuset(instance.getCpuset());
        this.withHostname(instance.getHostname());
        this.withDomainname(instance.getDomainname());
        this.withUser(instance.getUser());
        this.withMemory(instance.getMemory());
        this.withMemorySwap(instance.getMemorySwap());
        this.withMemoryReservation(instance.getMemoryReservation());
        this.withKernelMemory(instance.getKernelMemory());
        this.withCpuShares(instance.getCpuShares());
        this.withCpuPeriod(instance.getCpuPeriod());
        this.withCpuQuota(instance.getCpuQuota());
        this.withCpusetCpus(instance.getCpusetCpus());
        this.withCpusetMems(instance.getCpusetMems());
        this.withBlkioWeight(instance.getBlkioWeight());
        this.withMemorySwappiness(instance.getMemorySwappiness());
        this.withOomKillDisable(instance.getOomKillDisable());
        this.withAttachStdin(instance.getAttachStdin());
        this.withAttachStdout(instance.getAttachStdout());
        this.withAttachStderr(instance.getAttachStderr());
        this.withTty(instance.getTty());
        this.withOpenStdin(instance.getOpenStdin());
        this.withStdinOnce(instance.getStdinOnce());
        this.withEnv(instance.getEnv());
        this.withCmd(instance.getCmd());
        this.withEntrypoint(instance.getEntrypoint());
        this.withImage(instance.getImage());
        this.withLabels(instance.getLabels());
        this.withVolumes(instance.getVolumes());
        this.withWorkingDir(instance.getWorkingDir());
        this.withNetworkDisabled(instance.getNetworkDisabled());
        this.withMacAddress(instance.getMacAddress());
        this.withExposedPorts(instance.getExposedPorts());
        this.withStopSignal(instance.getStopSignal());
        this.withHostConfig(instance.getHostConfig());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public String getDomainname() {
        return this.domainname;
    }

    @Override
    public A withDomainname(String domainname) {
        this.domainname = domainname;
        return (A)this;
    }

    @Override
    public Boolean hasDomainname() {
        return this.domainname != null;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public String getMemory() {
        return this.memory;
    }

    @Override
    public A withMemory(String memory) {
        this.memory = memory;
        return (A)this;
    }

    @Override
    public Boolean hasMemory() {
        return this.memory != null;
    }

    @Override
    public String getMemorySwap() {
        return this.memorySwap;
    }

    @Override
    public A withMemorySwap(String memorySwap) {
        this.memorySwap = memorySwap;
        return (A)this;
    }

    @Override
    public Boolean hasMemorySwap() {
        return this.memorySwap != null;
    }

    @Override
    public String getMemoryReservation() {
        return this.memoryReservation;
    }

    @Override
    public A withMemoryReservation(String memoryReservation) {
        this.memoryReservation = memoryReservation;
        return (A)this;
    }

    @Override
    public Boolean hasMemoryReservation() {
        return this.memoryReservation != null;
    }

    @Override
    public String getKernelMemory() {
        return this.kernelMemory;
    }

    @Override
    public A withKernelMemory(String kernelMemory) {
        this.kernelMemory = kernelMemory;
        return (A)this;
    }

    @Override
    public Boolean hasKernelMemory() {
        return this.kernelMemory != null;
    }

    @Override
    public String getCpuShares() {
        return this.cpuShares;
    }

    @Override
    public A withCpuShares(String cpuShares) {
        this.cpuShares = cpuShares;
        return (A)this;
    }

    @Override
    public Boolean hasCpuShares() {
        return this.cpuShares != null;
    }

    @Override
    public String getCpuPeriod() {
        return this.cpuPeriod;
    }

    @Override
    public A withCpuPeriod(String cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return (A)this;
    }

    @Override
    public Boolean hasCpuPeriod() {
        return this.cpuPeriod != null;
    }

    @Override
    public String getCpuQuota() {
        return this.cpuQuota;
    }

    @Override
    public A withCpuQuota(String cpuQuota) {
        this.cpuQuota = cpuQuota;
        return (A)this;
    }

    @Override
    public Boolean hasCpuQuota() {
        return this.cpuQuota != null;
    }

    @Override
    public String getCpuset() {
        return this.cpuset;
    }

    @Override
    public A withCpuset(String cpuset) {
        this.cpuset = cpuset;
        return (A)this;
    }

    @Override
    public Boolean hasCpuset() {
        return this.cpuset != null;
    }

    @Override
    public String getCpusetCpus() {
        return this.cpusetCpus;
    }

    @Override
    public A withCpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
        return (A)this;
    }

    @Override
    public Boolean hasCpusetCpus() {
        return this.cpusetCpus != null;
    }

    @Override
    public String getCpusetMems() {
        return this.cpusetMems;
    }

    @Override
    public A withCpusetMems(String cpusetMems) {
        this.cpusetMems = cpusetMems;
        return (A)this;
    }

    @Override
    public Boolean hasCpusetMems() {
        return this.cpusetMems != null;
    }

    @Override
    public Integer getBlkioWeight() {
        return this.blkioWeight;
    }

    @Override
    public A withBlkioWeight(Integer blkioWeight) {
        this.blkioWeight = blkioWeight;
        return (A)this;
    }

    @Override
    public Boolean hasBlkioWeight() {
        return this.blkioWeight != null;
    }

    @Override
    public Integer getMemorySwappiness() {
        return this.memorySwappiness;
    }

    @Override
    public A withMemorySwappiness(Integer memorySwappiness) {
        this.memorySwappiness = memorySwappiness;
        return (A)this;
    }

    @Override
    public Boolean hasMemorySwappiness() {
        return this.memorySwappiness != null;
    }

    @Override
    public Boolean isOomKillDisable() {
        return this.oomKillDisable;
    }

    @Override
    public A withOomKillDisable(Boolean oomKillDisable) {
        this.oomKillDisable = oomKillDisable;
        return (A)this;
    }

    @Override
    public Boolean hasOomKillDisable() {
        return this.oomKillDisable != null;
    }

    @Override
    public Boolean isAttachStdin() {
        return this.attachStdin;
    }

    @Override
    public A withAttachStdin(Boolean attachStdin) {
        this.attachStdin = attachStdin;
        return (A)this;
    }

    @Override
    public Boolean hasAttachStdin() {
        return this.attachStdin != null;
    }

    @Override
    public Boolean isAttachStdout() {
        return this.attachStdout;
    }

    @Override
    public A withAttachStdout(Boolean attachStdout) {
        this.attachStdout = attachStdout;
        return (A)this;
    }

    @Override
    public Boolean hasAttachStdout() {
        return this.attachStdout != null;
    }

    @Override
    public Boolean isAttachStderr() {
        return this.attachStderr;
    }

    @Override
    public A withAttachStderr(Boolean attachStderr) {
        this.attachStderr = attachStderr;
        return (A)this;
    }

    @Override
    public Boolean hasAttachStderr() {
        return this.attachStderr != null;
    }

    @Override
    public Boolean isTty() {
        return this.tty;
    }

    @Override
    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)this;
    }

    @Override
    public Boolean hasTty() {
        return this.tty != null;
    }

    @Override
    public Boolean isOpenStdin() {
        return this.openStdin;
    }

    @Override
    public A withOpenStdin(Boolean openStdin) {
        this.openStdin = openStdin;
        return (A)this;
    }

    @Override
    public Boolean hasOpenStdin() {
        return this.openStdin != null;
    }

    @Override
    public Boolean isStdinOnce() {
        return this.stdinOnce;
    }

    @Override
    public A withStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return (A)this;
    }

    @Override
    public Boolean hasStdinOnce() {
        return this.stdinOnce != null;
    }

    @Override
    public A addToEnv(String key, String value) {
        if (key != null && value != null) {
            this.env.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(Map<String, String> map) {
        if (map != null) {
            this.env.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(String key) {
        if (key != null) {
            this.env.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.env.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Override
    public A withEnv(Map<String, String> env) {
        this.env.clear();
        if (env != null) {
            this.env.putAll(env);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null;
    }

    @Override
    public A addToCmd(int index, String item) {
        this.cmd.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCmd(int index, String item) {
        this.cmd.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCmd(String ... items) {
        for (String item : items) {
            this.cmd.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCmd(Collection<String> items) {
        for (String item : items) {
            this.cmd.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCmd(String ... items) {
        for (String item : items) {
            this.cmd.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCmd(Collection<String> items) {
        for (String item : items) {
            this.cmd.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCmd() {
        return this.cmd;
    }

    @Override
    public String getCmd(int index) {
        return this.cmd.get(index);
    }

    @Override
    public String getFirstCmd() {
        return this.cmd.get(0);
    }

    @Override
    public String getLastCmd() {
        return this.cmd.get(this.cmd.size() - 1);
    }

    @Override
    public String getMatchingCmd(Predicate<String> predicate) {
        for (String item : this.cmd) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withCmd(List<String> cmd) {
        this.cmd.clear();
        if (cmd != null) {
            for (String item : cmd) {
                this.addToCmd(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCmd(String ... cmd) {
        this.cmd.clear();
        if (cmd != null) {
            for (String item : cmd) {
                this.addToCmd(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCmd() {
        return this.cmd != null && !this.cmd.isEmpty();
    }

    @Override
    public String getEntrypoint() {
        return this.entrypoint;
    }

    @Override
    public A withEntrypoint(String entrypoint) {
        this.entrypoint = entrypoint;
        return (A)this;
    }

    @Override
    public Boolean hasEntrypoint() {
        return this.entrypoint != null;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (key != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public A withLabels(Map<String, String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.putAll(labels);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public A addToVolumes(String key, Object value) {
        if (key != null && value != null) {
            this.volumes.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Map<String, Object> map) {
        if (map != null) {
            this.volumes.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(String key) {
        if (key != null) {
            this.volumes.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.volumes.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getVolumes() {
        return this.volumes;
    }

    @Override
    public A withVolumes(Map<String, Object> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            this.volumes.putAll(volumes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)this;
    }

    @Override
    public Boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    @Override
    public Boolean isNetworkDisabled() {
        return this.networkDisabled;
    }

    @Override
    public A withNetworkDisabled(Boolean networkDisabled) {
        this.networkDisabled = networkDisabled;
        return (A)this;
    }

    @Override
    public Boolean hasNetworkDisabled() {
        return this.networkDisabled != null;
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public A withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return (A)this;
    }

    @Override
    public Boolean hasMacAddress() {
        return this.macAddress != null;
    }

    @Override
    public A addToExposedPorts(Integer key, Protocol value) {
        if (key != null && value != null) {
            this.exposedPorts.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExposedPorts(Map<Integer, Protocol> map) {
        if (map != null) {
            this.exposedPorts.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExposedPorts(Integer key) {
        if (key != null) {
            this.exposedPorts.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExposedPorts(Map<Integer, Protocol> map) {
        if (map != null) {
            for (Integer key : map.keySet()) {
                this.exposedPorts.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<Integer, Protocol> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public A withExposedPorts(Map<Integer, Protocol> exposedPorts) {
        this.exposedPorts.clear();
        if (exposedPorts != null) {
            this.exposedPorts.putAll(exposedPorts);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExposedPorts() {
        return this.exposedPorts != null;
    }

    @Override
    public String getStopSignal() {
        return this.stopSignal;
    }

    @Override
    public A withStopSignal(String stopSignal) {
        this.stopSignal = stopSignal;
        return (A)this;
    }

    @Override
    public Boolean hasStopSignal() {
        return this.stopSignal != null;
    }

    @Override
    @Deprecated
    public HostConfig getHostConfig() {
        return this.hostConfig != null ? this.hostConfig.build() : null;
    }

    @Override
    public HostConfig buildHostConfig() {
        return this.hostConfig != null ? this.hostConfig.build() : null;
    }

    @Override
    public A withHostConfig(HostConfig hostConfig) {
        this._visitables.remove(this.hostConfig);
        if (hostConfig != null) {
            this.hostConfig = new HostConfigBuilder(hostConfig);
            this._visitables.add(this.hostConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostConfig() {
        return this.hostConfig != null;
    }

    @Override
    public ContainerCreateRequestFluent.HostConfigNested<A> withNewHostConfig() {
        return new HostConfigNestedImpl();
    }

    @Override
    public ContainerCreateRequestFluent.HostConfigNested<A> withNewHostConfigLike(HostConfig item) {
        return new HostConfigNestedImpl(item);
    }

    @Override
    public ContainerCreateRequestFluent.HostConfigNested<A> editHostConfig() {
        return this.withNewHostConfigLike(this.getHostConfig());
    }

    @Override
    public ContainerCreateRequestFluent.HostConfigNested<A> editOrNewHostConfig() {
        return this.withNewHostConfigLike(this.getHostConfig() != null ? this.getHostConfig() : new HostConfigBuilder().build());
    }

    @Override
    public ContainerCreateRequestFluent.HostConfigNested<A> editOrNewHostConfigLike(HostConfig item) {
        return this.withNewHostConfigLike(this.getHostConfig() != null ? this.getHostConfig() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerCreateRequestFluentImpl that = (ContainerCreateRequestFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.domainname != null ? !this.domainname.equals(that.domainname) : that.domainname != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) {
            return false;
        }
        if (this.memorySwap != null ? !this.memorySwap.equals(that.memorySwap) : that.memorySwap != null) {
            return false;
        }
        if (this.memoryReservation != null ? !this.memoryReservation.equals(that.memoryReservation) : that.memoryReservation != null) {
            return false;
        }
        if (this.kernelMemory != null ? !this.kernelMemory.equals(that.kernelMemory) : that.kernelMemory != null) {
            return false;
        }
        if (this.cpuShares != null ? !this.cpuShares.equals(that.cpuShares) : that.cpuShares != null) {
            return false;
        }
        if (this.cpuPeriod != null ? !this.cpuPeriod.equals(that.cpuPeriod) : that.cpuPeriod != null) {
            return false;
        }
        if (this.cpuQuota != null ? !this.cpuQuota.equals(that.cpuQuota) : that.cpuQuota != null) {
            return false;
        }
        if (this.cpuset != null ? !this.cpuset.equals(that.cpuset) : that.cpuset != null) {
            return false;
        }
        if (this.cpusetCpus != null ? !this.cpusetCpus.equals(that.cpusetCpus) : that.cpusetCpus != null) {
            return false;
        }
        if (this.cpusetMems != null ? !this.cpusetMems.equals(that.cpusetMems) : that.cpusetMems != null) {
            return false;
        }
        if (this.blkioWeight != null ? !this.blkioWeight.equals(that.blkioWeight) : that.blkioWeight != null) {
            return false;
        }
        if (this.memorySwappiness != null ? !this.memorySwappiness.equals(that.memorySwappiness) : that.memorySwappiness != null) {
            return false;
        }
        if (this.oomKillDisable != null ? !this.oomKillDisable.equals(that.oomKillDisable) : that.oomKillDisable != null) {
            return false;
        }
        if (this.attachStdin != null ? !this.attachStdin.equals(that.attachStdin) : that.attachStdin != null) {
            return false;
        }
        if (this.attachStdout != null ? !this.attachStdout.equals(that.attachStdout) : that.attachStdout != null) {
            return false;
        }
        if (this.attachStderr != null ? !this.attachStderr.equals(that.attachStderr) : that.attachStderr != null) {
            return false;
        }
        if (this.tty != null ? !this.tty.equals(that.tty) : that.tty != null) {
            return false;
        }
        if (this.openStdin != null ? !this.openStdin.equals(that.openStdin) : that.openStdin != null) {
            return false;
        }
        if (this.stdinOnce != null ? !this.stdinOnce.equals(that.stdinOnce) : that.stdinOnce != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.cmd != null ? !this.cmd.equals(that.cmd) : that.cmd != null) {
            return false;
        }
        if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        if (this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null) {
            return false;
        }
        if (this.networkDisabled != null ? !this.networkDisabled.equals(that.networkDisabled) : that.networkDisabled != null) {
            return false;
        }
        if (this.macAddress != null ? !this.macAddress.equals(that.macAddress) : that.macAddress != null) {
            return false;
        }
        if (this.exposedPorts != null ? !this.exposedPorts.equals(that.exposedPorts) : that.exposedPorts != null) {
            return false;
        }
        if (this.stopSignal != null ? !this.stopSignal.equals(that.stopSignal) : that.stopSignal != null) {
            return false;
        }
        return !(this.hostConfig != null ? !this.hostConfig.equals(that.hostConfig) : that.hostConfig != null);
    }

    public class HostConfigNestedImpl<N>
    extends HostConfigFluentImpl<ContainerCreateRequestFluent.HostConfigNested<N>>
    implements ContainerCreateRequestFluent.HostConfigNested<N>,
    Nested<N> {
        private final HostConfigBuilder builder;

        HostConfigNestedImpl(HostConfig item) {
            this.builder = new HostConfigBuilder(this, item);
        }

        HostConfigNestedImpl() {
            this.builder = new HostConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerCreateRequestFluentImpl.this.withHostConfig(this.builder.build());
        }

        @Override
        public N endHostConfig() {
            return this.and();
        }
    }
}

