/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerChange;
import io.fabric8.docker.api.model.ContainerChangeFluent;
import io.fabric8.docker.api.model.ContainerChangeFluentImpl;
import io.fabric8.docker.api.model.EditableContainerChange;

public class ContainerChangeBuilder
extends ContainerChangeFluentImpl<ContainerChangeBuilder>
implements VisitableBuilder<ContainerChange, ContainerChangeBuilder> {
    ContainerChangeFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerChangeBuilder() {
        this(true);
    }

    public ContainerChangeBuilder(Boolean validationEnabled) {
        this(new ContainerChange(), validationEnabled);
    }

    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerChange(), validationEnabled);
    }

    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent, ContainerChange instance) {
        this(fluent, instance, true);
    }

    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent, ContainerChange instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withKind(instance.getKind());
        fluent.withPath(instance.getPath());
        this.validationEnabled = validationEnabled;
    }

    public ContainerChangeBuilder(ContainerChange instance) {
        this(instance, (Boolean)true);
    }

    public ContainerChangeBuilder(ContainerChange instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withKind(instance.getKind());
        this.withPath(instance.getPath());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableContainerChange build() {
        EditableContainerChange buildable = new EditableContainerChange(this.fluent.getKind(), this.fluent.getPath());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerChangeBuilder that = (ContainerChangeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

