/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Container;
import io.fabric8.docker.api.model.ContainerFluent;
import io.fabric8.docker.api.model.ContainerFluentImpl;
import io.fabric8.docker.api.model.EditableContainer;

public class ContainerBuilder
extends ContainerFluentImpl<ContainerBuilder>
implements VisitableBuilder<Container, ContainerBuilder> {
    ContainerFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerBuilder() {
        this(true);
    }

    public ContainerBuilder(Boolean validationEnabled) {
        this(new Container(), validationEnabled);
    }

    public ContainerBuilder(ContainerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Container(), validationEnabled);
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Container instance) {
        this(fluent, instance, true);
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Container instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withId(instance.getId());
        fluent.withNames(instance.getNames());
        fluent.withImage(instance.getImage());
        fluent.withImageId(instance.getImageId());
        fluent.withCommand(instance.getCommand());
        fluent.withCreated(instance.getCreated());
        fluent.withPorts(instance.getPorts());
        fluent.withSizeRw(instance.getSizeRw());
        fluent.withSizeRootFs(instance.getSizeRootFs());
        fluent.withLabels(instance.getLabels());
        fluent.withStatus(instance.getStatus());
        fluent.withHostConfig(instance.getHostConfig());
        fluent.withSummaryNetworkSettings(instance.getSummaryNetworkSettings());
        this.validationEnabled = validationEnabled;
    }

    public ContainerBuilder(Container instance) {
        this(instance, (Boolean)true);
    }

    public ContainerBuilder(Container instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withId(instance.getId());
        this.withNames(instance.getNames());
        this.withImage(instance.getImage());
        this.withImageId(instance.getImageId());
        this.withCommand(instance.getCommand());
        this.withCreated(instance.getCreated());
        this.withPorts(instance.getPorts());
        this.withSizeRw(instance.getSizeRw());
        this.withSizeRootFs(instance.getSizeRootFs());
        this.withLabels(instance.getLabels());
        this.withStatus(instance.getStatus());
        this.withHostConfig(instance.getHostConfig());
        this.withSummaryNetworkSettings(instance.getSummaryNetworkSettings());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableContainer build() {
        EditableContainer buildable = new EditableContainer(this.fluent.getId(), this.fluent.getNames(), this.fluent.getImage(), this.fluent.getImageId(), this.fluent.getCommand(), this.fluent.getCreated(), this.fluent.getPorts(), this.fluent.getSizeRw(), this.fluent.getSizeRootFs(), this.fluent.getLabels(), this.fluent.getStatus(), this.fluent.getHostConfig(), this.fluent.getSummaryNetworkSettings());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerBuilder that = (ContainerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

