/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.CPUUsage;
import io.fabric8.docker.api.model.CPUUsageFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CPUUsageFluentImpl<A extends CPUUsageFluent<A>>
extends BaseFluent<A>
implements CPUUsageFluent<A> {
    private List<Long> percpuUsage = new ArrayList<Long>();
    private Long totalUsage;
    private Long usageInKernelmode;
    private Long usageInUsermode;

    public CPUUsageFluentImpl() {
    }

    public CPUUsageFluentImpl(CPUUsage instance) {
        this.withPercpuUsage(instance.getPercpuUsage());
        this.withTotalUsage(instance.getTotalUsage());
        this.withUsageInKernelmode(instance.getUsageInKernelmode());
        this.withUsageInUsermode(instance.getUsageInUsermode());
    }

    @Override
    public A addToPercpuUsage(int index, Long item) {
        this.percpuUsage.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPercpuUsage(int index, Long item) {
        this.percpuUsage.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPercpuUsage(Long ... items) {
        for (Long item : items) {
            this.percpuUsage.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPercpuUsage(Collection<Long> items) {
        for (Long item : items) {
            this.percpuUsage.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPercpuUsage(Long ... items) {
        for (Long item : items) {
            this.percpuUsage.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPercpuUsage(Collection<Long> items) {
        for (Long item : items) {
            this.percpuUsage.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Long> getPercpuUsage() {
        return this.percpuUsage;
    }

    @Override
    public Long getPercpuUsage(int index) {
        return this.percpuUsage.get(index);
    }

    @Override
    public Long getFirstPercpuUsage() {
        return this.percpuUsage.get(0);
    }

    @Override
    public Long getLastPercpuUsage() {
        return this.percpuUsage.get(this.percpuUsage.size() - 1);
    }

    @Override
    public Long getMatchingPercpuUsage(Predicate<Long> predicate) {
        for (Long item : this.percpuUsage) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withPercpuUsage(List<Long> percpuUsage) {
        this.percpuUsage.clear();
        if (percpuUsage != null) {
            for (Long item : percpuUsage) {
                this.addToPercpuUsage(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPercpuUsage(Long ... percpuUsage) {
        this.percpuUsage.clear();
        if (percpuUsage != null) {
            for (Long item : percpuUsage) {
                this.addToPercpuUsage(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPercpuUsage() {
        return this.percpuUsage != null && !this.percpuUsage.isEmpty();
    }

    @Override
    public Long getTotalUsage() {
        return this.totalUsage;
    }

    @Override
    public A withTotalUsage(Long totalUsage) {
        this.totalUsage = totalUsage;
        return (A)this;
    }

    @Override
    public Boolean hasTotalUsage() {
        return this.totalUsage != null;
    }

    @Override
    public Long getUsageInKernelmode() {
        return this.usageInKernelmode;
    }

    @Override
    public A withUsageInKernelmode(Long usageInKernelmode) {
        this.usageInKernelmode = usageInKernelmode;
        return (A)this;
    }

    @Override
    public Boolean hasUsageInKernelmode() {
        return this.usageInKernelmode != null;
    }

    @Override
    public Long getUsageInUsermode() {
        return this.usageInUsermode;
    }

    @Override
    public A withUsageInUsermode(Long usageInUsermode) {
        this.usageInUsermode = usageInUsermode;
        return (A)this;
    }

    @Override
    public Boolean hasUsageInUsermode() {
        return this.usageInUsermode != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUUsageFluentImpl that = (CPUUsageFluentImpl)o;
        if (this.percpuUsage != null ? !this.percpuUsage.equals(that.percpuUsage) : that.percpuUsage != null) {
            return false;
        }
        if (this.totalUsage != null ? !this.totalUsage.equals(that.totalUsage) : that.totalUsage != null) {
            return false;
        }
        if (this.usageInKernelmode != null ? !this.usageInKernelmode.equals(that.usageInKernelmode) : that.usageInKernelmode != null) {
            return false;
        }
        return !(this.usageInUsermode != null ? !this.usageInUsermode.equals(that.usageInUsermode) : that.usageInUsermode != null);
    }
}

