/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.AuthResponse;
import io.fabric8.docker.api.model.AuthResponseFluent;
import io.fabric8.docker.api.model.AuthResponseFluentImpl;
import io.fabric8.docker.api.model.EditableAuthResponse;

public class AuthResponseBuilder
extends AuthResponseFluentImpl<AuthResponseBuilder>
implements VisitableBuilder<AuthResponse, AuthResponseBuilder> {
    AuthResponseFluent<?> fluent;
    Boolean validationEnabled;

    public AuthResponseBuilder() {
        this(true);
    }

    public AuthResponseBuilder(Boolean validationEnabled) {
        this(new AuthResponse(), validationEnabled);
    }

    public AuthResponseBuilder(AuthResponseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AuthResponseBuilder(AuthResponseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AuthResponse(), validationEnabled);
    }

    public AuthResponseBuilder(AuthResponseFluent<?> fluent, AuthResponse instance) {
        this(fluent, instance, true);
    }

    public AuthResponseBuilder(AuthResponseFluent<?> fluent, AuthResponse instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public AuthResponseBuilder(AuthResponse instance) {
        this(instance, (Boolean)true);
    }

    public AuthResponseBuilder(AuthResponse instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableAuthResponse build() {
        EditableAuthResponse buildable = new EditableAuthResponse(this.fluent.getStatus());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthResponseBuilder that = (AuthResponseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

