
package io.fabric8.docker.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.docker.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "io_merged_recursive",
    "io_queue_recursive",
    "io_service_bytes_recursive",
    "io_service_time_recursive",
    "io_serviced_recursive",
    "io_time_recursive",
    "io_wait_time_recursive",
    "sectors_recursive"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.docker.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
})
public class BlkioStats implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("io_merged_recursive")
    @Valid
    private List<BlkioStatEntry> ioMergedRecursive = new ArrayList<BlkioStatEntry>();
    /**
     * 
     * 
     */
    @JsonProperty("io_queue_recursive")
    @Valid
    private List<BlkioStatEntry> ioQueueRecursive = new ArrayList<BlkioStatEntry>();
    /**
     * 
     * 
     */
    @JsonProperty("io_service_bytes_recursive")
    @Valid
    private List<BlkioStatEntry> ioServiceBytesRecursive = new ArrayList<BlkioStatEntry>();
    /**
     * 
     * 
     */
    @JsonProperty("io_service_time_recursive")
    @Valid
    private List<BlkioStatEntry> ioServiceTimeRecursive = new ArrayList<BlkioStatEntry>();
    /**
     * 
     * 
     */
    @JsonProperty("io_serviced_recursive")
    @Valid
    private List<BlkioStatEntry> ioServicedRecursive = new ArrayList<BlkioStatEntry>();
    /**
     * 
     * 
     */
    @JsonProperty("io_time_recursive")
    @Valid
    private List<BlkioStatEntry> ioTimeRecursive = new ArrayList<BlkioStatEntry>();
    /**
     * 
     * 
     */
    @JsonProperty("io_wait_time_recursive")
    @Valid
    private List<BlkioStatEntry> ioWaitTimeRecursive = new ArrayList<BlkioStatEntry>();
    /**
     * 
     * 
     */
    @JsonProperty("sectors_recursive")
    @Valid
    private List<BlkioStatEntry> sectorsRecursive = new ArrayList<BlkioStatEntry>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BlkioStats() {
    }

    /**
     * 
     * @param ioServicedRecursive
     * @param ioTimeRecursive
     * @param sectorsRecursive
     * @param ioMergedRecursive
     * @param ioServiceTimeRecursive
     * @param ioWaitTimeRecursive
     * @param ioServiceBytesRecursive
     * @param ioQueueRecursive
     */
    public BlkioStats(List<BlkioStatEntry> ioMergedRecursive, List<BlkioStatEntry> ioQueueRecursive, List<BlkioStatEntry> ioServiceBytesRecursive, List<BlkioStatEntry> ioServiceTimeRecursive, List<BlkioStatEntry> ioServicedRecursive, List<BlkioStatEntry> ioTimeRecursive, List<BlkioStatEntry> ioWaitTimeRecursive, List<BlkioStatEntry> sectorsRecursive) {
        this.ioMergedRecursive = ioMergedRecursive;
        this.ioQueueRecursive = ioQueueRecursive;
        this.ioServiceBytesRecursive = ioServiceBytesRecursive;
        this.ioServiceTimeRecursive = ioServiceTimeRecursive;
        this.ioServicedRecursive = ioServicedRecursive;
        this.ioTimeRecursive = ioTimeRecursive;
        this.ioWaitTimeRecursive = ioWaitTimeRecursive;
        this.sectorsRecursive = sectorsRecursive;
    }

    /**
     * 
     * 
     * @return
     *     The ioMergedRecursive
     */
    @JsonProperty("io_merged_recursive")
    public List<BlkioStatEntry> getIoMergedRecursive() {
        return ioMergedRecursive;
    }

    /**
     * 
     * 
     * @param ioMergedRecursive
     *     The io_merged_recursive
     */
    @JsonProperty("io_merged_recursive")
    public void setIoMergedRecursive(List<BlkioStatEntry> ioMergedRecursive) {
        this.ioMergedRecursive = ioMergedRecursive;
    }

    /**
     * 
     * 
     * @return
     *     The ioQueueRecursive
     */
    @JsonProperty("io_queue_recursive")
    public List<BlkioStatEntry> getIoQueueRecursive() {
        return ioQueueRecursive;
    }

    /**
     * 
     * 
     * @param ioQueueRecursive
     *     The io_queue_recursive
     */
    @JsonProperty("io_queue_recursive")
    public void setIoQueueRecursive(List<BlkioStatEntry> ioQueueRecursive) {
        this.ioQueueRecursive = ioQueueRecursive;
    }

    /**
     * 
     * 
     * @return
     *     The ioServiceBytesRecursive
     */
    @JsonProperty("io_service_bytes_recursive")
    public List<BlkioStatEntry> getIoServiceBytesRecursive() {
        return ioServiceBytesRecursive;
    }

    /**
     * 
     * 
     * @param ioServiceBytesRecursive
     *     The io_service_bytes_recursive
     */
    @JsonProperty("io_service_bytes_recursive")
    public void setIoServiceBytesRecursive(List<BlkioStatEntry> ioServiceBytesRecursive) {
        this.ioServiceBytesRecursive = ioServiceBytesRecursive;
    }

    /**
     * 
     * 
     * @return
     *     The ioServiceTimeRecursive
     */
    @JsonProperty("io_service_time_recursive")
    public List<BlkioStatEntry> getIoServiceTimeRecursive() {
        return ioServiceTimeRecursive;
    }

    /**
     * 
     * 
     * @param ioServiceTimeRecursive
     *     The io_service_time_recursive
     */
    @JsonProperty("io_service_time_recursive")
    public void setIoServiceTimeRecursive(List<BlkioStatEntry> ioServiceTimeRecursive) {
        this.ioServiceTimeRecursive = ioServiceTimeRecursive;
    }

    /**
     * 
     * 
     * @return
     *     The ioServicedRecursive
     */
    @JsonProperty("io_serviced_recursive")
    public List<BlkioStatEntry> getIoServicedRecursive() {
        return ioServicedRecursive;
    }

    /**
     * 
     * 
     * @param ioServicedRecursive
     *     The io_serviced_recursive
     */
    @JsonProperty("io_serviced_recursive")
    public void setIoServicedRecursive(List<BlkioStatEntry> ioServicedRecursive) {
        this.ioServicedRecursive = ioServicedRecursive;
    }

    /**
     * 
     * 
     * @return
     *     The ioTimeRecursive
     */
    @JsonProperty("io_time_recursive")
    public List<BlkioStatEntry> getIoTimeRecursive() {
        return ioTimeRecursive;
    }

    /**
     * 
     * 
     * @param ioTimeRecursive
     *     The io_time_recursive
     */
    @JsonProperty("io_time_recursive")
    public void setIoTimeRecursive(List<BlkioStatEntry> ioTimeRecursive) {
        this.ioTimeRecursive = ioTimeRecursive;
    }

    /**
     * 
     * 
     * @return
     *     The ioWaitTimeRecursive
     */
    @JsonProperty("io_wait_time_recursive")
    public List<BlkioStatEntry> getIoWaitTimeRecursive() {
        return ioWaitTimeRecursive;
    }

    /**
     * 
     * 
     * @param ioWaitTimeRecursive
     *     The io_wait_time_recursive
     */
    @JsonProperty("io_wait_time_recursive")
    public void setIoWaitTimeRecursive(List<BlkioStatEntry> ioWaitTimeRecursive) {
        this.ioWaitTimeRecursive = ioWaitTimeRecursive;
    }

    /**
     * 
     * 
     * @return
     *     The sectorsRecursive
     */
    @JsonProperty("sectors_recursive")
    public List<BlkioStatEntry> getSectorsRecursive() {
        return sectorsRecursive;
    }

    /**
     * 
     * 
     * @param sectorsRecursive
     *     The sectors_recursive
     */
    @JsonProperty("sectors_recursive")
    public void setSectorsRecursive(List<BlkioStatEntry> sectorsRecursive) {
        this.sectorsRecursive = sectorsRecursive;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
