package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface VolumesListResponseFluent<A extends VolumesListResponseFluent<A>> extends Fluent<A>{


    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 */
@Deprecated public List<Volume> getVolumes();
    public List<Volume> buildVolumes();
    public Volume buildVolume(int index);
    public Volume buildFirstVolume();
    public Volume buildLastVolume();
    public Volume buildMatchingVolume(io.fabric8.docker.api.builder.Predicate<VolumeBuilder> predicate);
    public A withVolumes(List<Volume> Volumes);
    public A withVolumes(Volume... Volumes);
    public Boolean hasVolumes();
    public VolumesListResponseFluent.VolumesNested<A> addNewVolume();
    public VolumesListResponseFluent.VolumesNested<A> addNewVolumeLike(Volume item);
    public VolumesListResponseFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item);
    public VolumesListResponseFluent.VolumesNested<A> editVolume(int index);
    public VolumesListResponseFluent.VolumesNested<A> editFirstVolume();
    public VolumesListResponseFluent.VolumesNested<A> editLastVolume();
    public VolumesListResponseFluent.VolumesNested<A> editMatchingVolume(io.fabric8.docker.api.builder.Predicate<VolumeBuilder> predicate);
    public A addNewVolume(String Driver,String Mountpoint,String Name);

    public interface VolumesNested<N> extends io.fabric8.docker.api.builder.Nested<N>,VolumeFluent<VolumesListResponseFluent.VolumesNested<N>>{

        
    public N and();    public N endVolume();
}


}
