package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumesListResponseBuilder extends VolumesListResponseFluentImpl<VolumesListResponseBuilder> implements VisitableBuilder<VolumesListResponse,VolumesListResponseBuilder>{

    VolumesListResponseFluent<?> fluent;
    Boolean validationEnabled;

    public VolumesListResponseBuilder(){
            this(true);
    }
    public VolumesListResponseBuilder(Boolean validationEnabled){
            this(new VolumesListResponse(), validationEnabled);
    }
    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent){
            this(fluent, true);
    }
    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VolumesListResponse(), validationEnabled);
    }
    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent,VolumesListResponse instance){
            this(fluent, instance, true);
    }
    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent,VolumesListResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }
    public VolumesListResponseBuilder(VolumesListResponse instance){
            this(instance,true);
    }
    public VolumesListResponseBuilder(VolumesListResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableVolumesListResponse build(){
            EditableVolumesListResponse buildable = new EditableVolumesListResponse(fluent.getVolumes());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumesListResponseBuilder that = (VolumesListResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
