package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class VersionFluentImpl<A extends VersionFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements VersionFluent<A>{

    private String ApiVersion;
    private String Arch;
    private String BuildTime;
    private Boolean Experimental;
    private String GitCommit;
    private String GoVersion;
    private String KernelVersion;
    private String Os;
    private String Version;

    public VersionFluentImpl(){
    }
    public VersionFluentImpl(io.fabric8.docker.api.model.Version instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withArch(instance.getArch()); 
            this.withBuildTime(instance.getBuildTime()); 
            this.withExperimental(instance.getExperimental()); 
            this.withGitCommit(instance.getGitCommit()); 
            this.withGoVersion(instance.getGoVersion()); 
            this.withKernelVersion(instance.getKernelVersion()); 
            this.withOs(instance.getOs()); 
            this.withVersion(instance.getVersion()); 
    }

    public String getApiVersion(){
            return this.ApiVersion;
    }

    public A withApiVersion(String ApiVersion){
            this.ApiVersion=ApiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.ApiVersion!=null;
    }

    public String getArch(){
            return this.Arch;
    }

    public A withArch(String Arch){
            this.Arch=Arch; return (A) this;
    }

    public Boolean hasArch(){
            return this.Arch!=null;
    }

    public String getBuildTime(){
            return this.BuildTime;
    }

    public A withBuildTime(String BuildTime){
            this.BuildTime=BuildTime; return (A) this;
    }

    public Boolean hasBuildTime(){
            return this.BuildTime!=null;
    }

    public Boolean isExperimental(){
            return this.Experimental;
    }

    public A withExperimental(Boolean Experimental){
            this.Experimental=Experimental; return (A) this;
    }

    public Boolean hasExperimental(){
            return this.Experimental!=null;
    }

    public String getGitCommit(){
            return this.GitCommit;
    }

    public A withGitCommit(String GitCommit){
            this.GitCommit=GitCommit; return (A) this;
    }

    public Boolean hasGitCommit(){
            return this.GitCommit!=null;
    }

    public String getGoVersion(){
            return this.GoVersion;
    }

    public A withGoVersion(String GoVersion){
            this.GoVersion=GoVersion; return (A) this;
    }

    public Boolean hasGoVersion(){
            return this.GoVersion!=null;
    }

    public String getKernelVersion(){
            return this.KernelVersion;
    }

    public A withKernelVersion(String KernelVersion){
            this.KernelVersion=KernelVersion; return (A) this;
    }

    public Boolean hasKernelVersion(){
            return this.KernelVersion!=null;
    }

    public String getOs(){
            return this.Os;
    }

    public A withOs(String Os){
            this.Os=Os; return (A) this;
    }

    public Boolean hasOs(){
            return this.Os!=null;
    }

    public String getVersion(){
            return this.Version;
    }

    public A withVersion(String Version){
            this.Version=Version; return (A) this;
    }

    public Boolean hasVersion(){
            return this.Version!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VersionFluentImpl that = (VersionFluentImpl) o;
            if (ApiVersion != null ? !ApiVersion.equals(that.ApiVersion) :that.ApiVersion != null) return false;
            if (Arch != null ? !Arch.equals(that.Arch) :that.Arch != null) return false;
            if (BuildTime != null ? !BuildTime.equals(that.BuildTime) :that.BuildTime != null) return false;
            if (Experimental != null ? !Experimental.equals(that.Experimental) :that.Experimental != null) return false;
            if (GitCommit != null ? !GitCommit.equals(that.GitCommit) :that.GitCommit != null) return false;
            if (GoVersion != null ? !GoVersion.equals(that.GoVersion) :that.GoVersion != null) return false;
            if (KernelVersion != null ? !KernelVersion.equals(that.KernelVersion) :that.KernelVersion != null) return false;
            if (Os != null ? !Os.equals(that.Os) :that.Os != null) return false;
            if (Version != null ? !Version.equals(that.Version) :that.Version != null) return false;
            return true;
    }




}
