package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SearchResultBuilder extends SearchResultFluentImpl<SearchResultBuilder> implements VisitableBuilder<SearchResult,SearchResultBuilder>{

    SearchResultFluent<?> fluent;
    Boolean validationEnabled;

    public SearchResultBuilder(){
            this(true);
    }
    public SearchResultBuilder(Boolean validationEnabled){
            this(new SearchResult(), validationEnabled);
    }
    public SearchResultBuilder(SearchResultFluent<?> fluent){
            this(fluent, true);
    }
    public SearchResultBuilder(SearchResultFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SearchResult(), validationEnabled);
    }
    public SearchResultBuilder(SearchResultFluent<?> fluent,SearchResult instance){
            this(fluent, instance, true);
    }
    public SearchResultBuilder(SearchResultFluent<?> fluent,SearchResult instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDescription(instance.getDescription()); 
            fluent.withIsAutomated(instance.getIsAutomated()); 
            fluent.withIsOfficial(instance.getIsOfficial()); 
            fluent.withIsTrusted(instance.getIsTrusted()); 
            fluent.withName(instance.getName()); 
            fluent.withStarCount(instance.getStarCount()); 
            this.validationEnabled = validationEnabled; 
    }
    public SearchResultBuilder(SearchResult instance){
            this(instance,true);
    }
    public SearchResultBuilder(SearchResult instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDescription(instance.getDescription()); 
            this.withIsAutomated(instance.getIsAutomated()); 
            this.withIsOfficial(instance.getIsOfficial()); 
            this.withIsTrusted(instance.getIsTrusted()); 
            this.withName(instance.getName()); 
            this.withStarCount(instance.getStarCount()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableSearchResult build(){
            EditableSearchResult buildable = new EditableSearchResult(fluent.getDescription(),fluent.isIsAutomated(),fluent.isIsOfficial(),fluent.isIsTrusted(),fluent.getName(),fluent.getStarCount());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SearchResultBuilder that = (SearchResultBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
