package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface NetworkCreateFluent<A extends NetworkCreateFluent<A>> extends Fluent<A>{


    public Boolean isCheckDuplicate();
    public A withCheckDuplicate(Boolean CheckDuplicate);
    public Boolean hasCheckDuplicate();
    public String getDriver();
    public A withDriver(String Driver);
    public Boolean hasDriver();
    
/**
 * This method has been deprecated, please use method buildIPAM instead.
 */
@Deprecated public IPAM getIPAM();
    public IPAM buildIPAM();
    public A withIPAM(IPAM IPAM);
    public Boolean hasIPAM();
    public NetworkCreateFluent.IPAMNested<A> withNewIPAM();
    public NetworkCreateFluent.IPAMNested<A> withNewIPAMLike(IPAM item);
    public NetworkCreateFluent.IPAMNested<A> editIPAM();
    public NetworkCreateFluent.IPAMNested<A> editOrNewIPAM();
    public NetworkCreateFluent.IPAMNested<A> editOrNewIPAMLike(IPAM item);
    public String getName();
    public A withName(String Name);
    public Boolean hasName();
    public A addToOptions(String key,String value);
    public A addToOptions(Map<String,String> map);
    public A removeFromOptions(String key);
    public A removeFromOptions(Map<String,String> map);
    public Map<String,String> getOptions();
    public A withOptions(Map<String,String> Options);
    public Boolean hasOptions();

    public interface IPAMNested<N> extends io.fabric8.docker.api.builder.Nested<N>,IPAMFluent<NetworkCreateFluent.IPAMNested<N>>{

        
    public N and();    public N endIPAM();
}


}
