package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkConnectBuilder extends NetworkConnectFluentImpl<NetworkConnectBuilder> implements VisitableBuilder<NetworkConnect,NetworkConnectBuilder>{

    NetworkConnectFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkConnectBuilder(){
            this(true);
    }
    public NetworkConnectBuilder(Boolean validationEnabled){
            this(new NetworkConnect(), validationEnabled);
    }
    public NetworkConnectBuilder(NetworkConnectFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkConnectBuilder(NetworkConnectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkConnect(), validationEnabled);
    }
    public NetworkConnectBuilder(NetworkConnectFluent<?> fluent,NetworkConnect instance){
            this(fluent, instance, true);
    }
    public NetworkConnectBuilder(NetworkConnectFluent<?> fluent,NetworkConnect instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContainer(instance.getContainer()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkConnectBuilder(NetworkConnect instance){
            this(instance,true);
    }
    public NetworkConnectBuilder(NetworkConnect instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContainer(instance.getContainer()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkConnect build(){
            EditableNetworkConnect buildable = new EditableNetworkConnect(fluent.getContainer());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkConnectBuilder that = (NetworkConnectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
