package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ImageDeleteFluentImpl<A extends ImageDeleteFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ImageDeleteFluent<A>{

    private String Deleted;
    private String Untagged;

    public ImageDeleteFluentImpl(){
    }
    public ImageDeleteFluentImpl(ImageDelete instance){
            this.withDeleted(instance.getDeleted()); 
            this.withUntagged(instance.getUntagged()); 
    }

    public String getDeleted(){
            return this.Deleted;
    }

    public A withDeleted(String Deleted){
            this.Deleted=Deleted; return (A) this;
    }

    public Boolean hasDeleted(){
            return this.Deleted!=null;
    }

    public String getUntagged(){
            return this.Untagged;
    }

    public A withUntagged(String Untagged){
            this.Untagged=Untagged; return (A) this;
    }

    public Boolean hasUntagged(){
            return this.Untagged!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageDeleteFluentImpl that = (ImageDeleteFluentImpl) o;
            if (Deleted != null ? !Deleted.equals(that.Deleted) :that.Deleted != null) return false;
            if (Untagged != null ? !Untagged.equals(that.Untagged) :that.Untagged != null) return false;
            return true;
    }




}
