package io.fabric8.docker.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface EndpointSettingsFluent<A extends EndpointSettingsFluent<A>> extends Fluent<A>{


    public String getEndpointID();
    public A withEndpointID(String EndpointID);
    public Boolean hasEndpointID();
    public String getGateway();
    public A withGateway(String Gateway);
    public Boolean hasGateway();
    public String getGlobalIPv6Address();
    public A withGlobalIPv6Address(String GlobalIPv6Address);
    public Boolean hasGlobalIPv6Address();
    public Integer getGlobalIPv6PrefixLen();
    public A withGlobalIPv6PrefixLen(Integer GlobalIPv6PrefixLen);
    public Boolean hasGlobalIPv6PrefixLen();
    public String getIPAddress();
    public A withIPAddress(String IPAddress);
    public Boolean hasIPAddress();
    public Integer getIPPrefixLen();
    public A withIPPrefixLen(Integer IPPrefixLen);
    public Boolean hasIPPrefixLen();
    public String getIPv6Gateway();
    public A withIPv6Gateway(String IPv6Gateway);
    public Boolean hasIPv6Gateway();
    public String getMacAddress();
    public A withMacAddress(String MacAddress);
    public Boolean hasMacAddress();



}
